/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer afc;
    private final TurnBasedMatchBuffer afd;
    private final TurnBasedMatchBuffer afe;
    private final TurnBasedMatchBuffer aff;

    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zzc(bundle, 0);
        this.afc = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zzc(bundle, 1);
        this.afd = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zzc(bundle, 2);
        this.afe = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zzc(bundle, 3);
        this.aff = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder zzc(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.zzrw(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.afc;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.afd;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.afe;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.aff;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.afc != null) {
            this.afc.release();
        }
        if (this.afd != null) {
            this.afd.release();
        }
        if (this.afe != null) {
            this.afe.release();
        }
        if (this.aff != null) {
            this.aff.release();
        }
    }

    public boolean hasData() {
        if (this.afc != null && this.afc.getCount() > 0) {
            return true;
        }
        if (this.afd != null && this.afd.getCount() > 0) {
            return true;
        }
        if (this.afe != null && this.afe.getCount() > 0) {
            return true;
        }
        return this.aff != null && this.aff.getCount() > 0;
    }
}

