/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
extends AbstractSafeParcelable
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new QuestEntityCreator();
    private final int mVersionCode;
    private final GameEntity acT;
    private final String afu;
    private final long afv;
    private final Uri afw;
    private final String afx;
    private final String cg;
    private final long afy;
    private final long Yh;
    private final Uri mIconUri;
    private final String afz;
    private final String mName;
    private final long afA;
    private final long afB;
    private final int mState;
    private final int nV;
    private final ArrayList<MilestoneEntity> afC;

    public QuestEntity(Quest quest) {
        this.mVersionCode = 2;
        this.acT = new GameEntity(quest.getGame());
        this.afu = quest.getQuestId();
        this.afv = quest.getAcceptedTimestamp();
        this.cg = quest.getDescription();
        this.afw = quest.getBannerImageUri();
        this.afx = quest.getBannerImageUrl();
        this.afy = quest.getEndTimestamp();
        this.mIconUri = quest.getIconImageUri();
        this.afz = quest.getIconImageUrl();
        this.Yh = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.afA = quest.zzbmw();
        this.afB = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.nV = quest.getType();
        List<Milestone> list = quest.zzbmv();
        int n = list.size();
        this.afC = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.afC.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int n, GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n2, int n3, ArrayList<MilestoneEntity> arrayList) {
        this.mVersionCode = n;
        this.acT = gameEntity;
        this.afu = string;
        this.afv = l;
        this.afw = uri;
        this.afx = string2;
        this.cg = string3;
        this.afy = l2;
        this.Yh = l3;
        this.mIconUri = uri2;
        this.afz = string4;
        this.mName = string5;
        this.afA = l4;
        this.afB = l5;
        this.mState = n2;
        this.nV = n3;
        this.afC = arrayList;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getQuestId() {
        return this.afu;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.cg;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.cg, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.mIconUri;
    }

    @Override
    public String getIconImageUrl() {
        return this.afz;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.afw;
    }

    @Override
    public String getBannerImageUrl() {
        return this.afx;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzbmv().get(0);
    }

    @Override
    public List<Milestone> zzbmv() {
        return new ArrayList<Milestone>(this.afC);
    }

    @Override
    public Game getGame() {
        return this.acT;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.nV;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.afv;
    }

    @Override
    public long getEndTimestamp() {
        return this.afy;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Yh;
    }

    @Override
    public long zzbmw() {
        return this.afA;
    }

    @Override
    public long getStartTimestamp() {
        return this.afB;
    }

    @Override
    public boolean isEndingSoon() {
        return this.afA <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzz.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzbmv(), quest.getName(), quest.zzbmw(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzz.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzz.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzz.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzz.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzz.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzz.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzz.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzz.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzz.equal(quest2.zzbmv(), quest.zzbmv()) && zzz.equal((Object)quest2.getName(), (Object)quest.getName()) && zzz.equal((Object)quest2.zzbmw(), (Object)quest.zzbmw()) && zzz.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzz.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzz.zzx((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzbmv()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzbmw()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        QuestEntityCreator.zza(this, parcel, n);
    }
}

