/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzbmy();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String cg;
        private Long afK;
        private Long afL;
        private BitmapTeleporter afM;
        private Uri afN;

        public Builder setDescription(String string) {
            this.cg = string;
            return this;
        }

        public Builder setPlayedTimeMillis(long l) {
            this.afK = l;
            return this;
        }

        public Builder setProgressValue(long l) {
            this.afL = l;
            return this;
        }

        public Builder setCoverImage(Bitmap bitmap) {
            this.afM = new BitmapTeleporter(bitmap);
            this.afN = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.cg = snapshotMetadata.getDescription();
            this.afK = snapshotMetadata.getPlayedTime();
            this.afL = snapshotMetadata.getProgressValue();
            if (this.afK == -1L) {
                this.afK = null;
            }
            this.afN = snapshotMetadata.getCoverImageUri();
            if (this.afN != null) {
                this.afM = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.cg, this.afK, this.afM, this.afN, this.afL);
        }
    }
}

