/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.games.video.VideoCapabilitiesCreator;
import com.google.android.gms.games.video.VideoConfiguration;

public final class VideoCapabilities
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<VideoCapabilities> CREATOR = new VideoCapabilitiesCreator();
    private final int mVersionCode;
    private final boolean agq;
    private final boolean agr;
    private final boolean ags;
    private final boolean[] agt;
    private final boolean[] agu;

    public VideoCapabilities(int n, boolean bl, boolean bl2, boolean bl3, boolean[] blArray, boolean[] blArray2) {
        this.mVersionCode = n;
        this.agq = bl;
        this.agr = bl2;
        this.ags = bl3;
        this.agt = blArray;
        this.agu = blArray2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean isMicSupported() {
        return this.agr;
    }

    public boolean isCameraSupported() {
        return this.agq;
    }

    public boolean isWriteStorageSupported() {
        return this.ags;
    }

    public boolean[] zzbne() {
        return this.agt;
    }

    public boolean[] zzbnf() {
        return this.agu;
    }

    public boolean supportsCaptureMode(int n) {
        zzaa.zzbs((boolean)VideoConfiguration.isValidCaptureMode(n, false));
        return this.agt[n];
    }

    public boolean supportsQualityLevel(int n) {
        zzaa.zzbs((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        return this.agu[n];
    }

    public boolean isFullySupported(int n, int n2) {
        return this.agq && this.agr && this.ags && this.supportsCaptureMode(n) && this.supportsQualityLevel(n2);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzbne(), this.zzbnf(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()});
    }

    public boolean equals(Object object) {
        if (!(object instanceof VideoCapabilities)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VideoCapabilities videoCapabilities = (VideoCapabilities)((Object)object);
        return zzz.equal((Object)videoCapabilities.zzbne(), (Object)this.zzbne()) && zzz.equal((Object)videoCapabilities.zzbnf(), (Object)this.zzbnf()) && zzz.equal((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && zzz.equal((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && zzz.equal((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public String toString() {
        return zzz.zzx((Object)((Object)this)).zzg("SupportedCaptureModes", (Object)this.zzbne()).zzg("SupportedQualityLevels", (Object)this.zzbnf()).zzg("CameraSupported", (Object)this.isCameraSupported()).zzg("MicSupported", (Object)this.isMicSupported()).zzg("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoCapabilitiesCreator.zza(this, parcel, n);
    }
}

