/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzcm;
import com.google.android.gms.internal.ads.zzcs;
import com.google.android.gms.internal.ads.zzdb;
import com.google.android.gms.internal.ads.zzdyg;
import com.google.android.gms.internal.ads.zzdyi;
import com.google.android.gms.internal.ads.zzdyo;
import com.google.android.gms.internal.ads.zzdyt;
import com.google.android.gms.internal.ads.zzdyu;
import com.google.android.gms.internal.ads.zzdyv;
import com.google.android.gms.internal.ads.zzdyw;
import com.google.android.gms.internal.ads.zzdyx;
import com.google.android.gms.internal.ads.zzdyy;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class zzdyz {
    private final Context zza;
    private final Executor zzb;
    private final zzdyg zzc;
    private final zzdyi zzd;
    private final zzdyy zze;
    private final zzdyy zzf;
    private Task<zzdb> zzg;
    private Task<zzdb> zzh;

    @VisibleForTesting
    zzdyz(Context context, Executor executor, zzdyg zzdyg2, zzdyi zzdyi2, zzdyw zzdyw2, zzdyx zzdyx2) {
        this.zza = context;
        this.zzb = executor;
        this.zzc = zzdyg2;
        this.zzd = zzdyi2;
        this.zze = zzdyw2;
        this.zzf = zzdyx2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static zzdyz zza(@NonNull Context object, @NonNull Executor executor, @NonNull zzdyg zzdyg2, @NonNull zzdyi zzdyi2) {
        void var3_6;
        void var2_5;
        void var1_4;
        zzdyw zzdyw2 = new zzdyw();
        zzdyx zzdyx2 = new zzdyx();
        zzdyz zzdyz2 = new zzdyz((Context)object, (Executor)var1_4, (zzdyg)var2_5, (zzdyi)var3_6, zzdyw2, zzdyx2);
        if (zzdyz2.zzd.zzb()) {
            zzdyt zzdyt2 = new zzdyt(zzdyz2);
            zzdyz2.zzg = zzdyz2.zzg(zzdyt2);
        } else {
            zzdyz2.zzg = Tasks.forResult((Object)zzdyz2.zze.zza());
        }
        zzdyu zzdyu2 = new zzdyu(zzdyz2);
        zzdyz2.zzh = zzdyz2.zzg(zzdyu2);
        return zzdyz2;
    }

    public final zzdb zzb() {
        return zzdyz.zzh(this.zzg, this.zze.zza());
    }

    public final zzdb zzc() {
        return zzdyz.zzh(this.zzh, this.zzf.zza());
    }

    private final Task<zzdb> zzg(@NonNull Callable<zzdb> task) {
        Executor executor = this.zzb;
        task = Tasks.call((Executor)executor, task);
        executor = this.zzb;
        zzdyv zzdyv2 = new zzdyv(this);
        return task.addOnFailureListener(executor, (OnFailureListener)zzdyv2);
    }

    private static zzdb zzh(@NonNull Task<zzdb> task, @NonNull zzdb zzdb2) {
        if (!task.isSuccessful()) {
            return zzdb2;
        }
        return (zzdb)task.getResult();
    }

    final /* synthetic */ void zzd(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzc.zzd(2025, -1L, exception);
    }

    final /* synthetic */ zzdb zze() throws Exception {
        zzdyz zzdyz2 = zzdyz2.zza;
        PackageManager packageManager = zzdyz2.getPackageManager();
        String string = zzdyz2.getPackageName();
        packageManager = packageManager.getPackageInfo(string, 0);
        return zzdyo.zza((Context)zzdyz2, zzdyz2.getPackageName(), Integer.toString(packageManager.versionCode));
    }

    final /* synthetic */ zzdb zzf() throws Exception {
        Object object = ((zzdyz)object).zza;
        zzcm zzcm2 = zzdb.zzj();
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient((Context)object);
        advertisingIdClient.start();
        advertisingIdClient = advertisingIdClient.getInfo();
        object = advertisingIdClient.getId();
        if (object != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            object = Base64.encodeToString((byte[])byArray, (int)11);
        }
        if (object != null) {
            zzcm2.zzX((String)object);
            zzcm2.zzZ(advertisingIdClient.isLimitAdTrackingEnabled());
            zzcm2.zzY(zzcs.zzf);
        }
        return (zzdb)zzcm2.zzah();
    }
}

