/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.annotation.TargetApi;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.common.util.zzx;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.PendingCallback;
import com.google.android.gms.gcm.TaskParams;
import com.google.android.gms.gcm.zzd;
import com.google.android.gms.gcm.zze;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;

public abstract class GcmTaskService
extends Service {
    public static final String SERVICE_PERMISSION = "com.google.android.gms.permission.BIND_NETWORK_TASK_SERVICE";
    public static final String SERVICE_ACTION_EXECUTE_TASK = "com.google.android.gms.gcm.ACTION_TASK_READY";
    public static final String SERVICE_ACTION_INITIALIZE = "com.google.android.gms.gcm.SERVICE_ACTION_INITIALIZE";
    private final Object lock = new Object();
    private int zzicf;
    private ExecutorService zzais;
    private Messenger zzicg;
    private ComponentName componentName;
    private GcmNetworkManager zzich;

    public GcmTaskService() {
    }

    @CallSuper
    public void onCreate() {
        super.onCreate();
        this.zzich = GcmNetworkManager.getInstance((Context)this);
        GcmTaskService gcmTaskService = this;
        this.zzais = Executors.newFixedThreadPool(2, new com.google.android.gms.gcm.zzb(gcmTaskService));
        this.zzicg = new Messenger((Handler)new zza(this, Looper.getMainLooper()));
        this.componentName = new ComponentName((Context)this, ((Object)((Object)this)).getClass());
    }

    @CallSuper
    public void onDestroy() {
        super.onDestroy();
        List<Runnable> list = this.zzais.shutdownNow();
        if (!list.isEmpty()) {
            int n = list.size();
            Log.e((String)"GcmTaskService", (String)new StringBuilder(79).append("Shutting down, but not all tasks are finished executing. Remaining: ").append(n).toString());
        }
    }

    @CallSuper
    public int onStartCommand(Intent intent, int n, int n2) {
        if (intent == null) {
            this.zzdp(n2);
            return 2;
        }
        try {
            intent.setExtrasClassLoader(PendingCallback.class.getClassLoader());
            String string2 = intent.getAction();
            if (SERVICE_ACTION_EXECUTE_TASK.equals(string2)) {
                String string3 = intent.getStringExtra("tag");
                Parcelable parcelable = intent.getParcelableExtra("callback");
                Bundle bundle = intent.getBundleExtra("extras");
                ArrayList arrayList = intent.getParcelableArrayListExtra("triggered_uris");
                if (!(parcelable instanceof PendingCallback)) {
                    String string4 = this.getPackageName();
                    Log.e((String)"GcmTaskService", (String)new StringBuilder(47 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append(" ").append(string3).append(": Could not process request, invalid callback.").toString());
                    return 2;
                }
                if (this.zzhy(string3)) {
                    return 2;
                }
                IBinder iBinder = ((PendingCallback)parcelable).zzfzf;
                zzb zzb2 = new zzb(this, string3, iBinder, bundle, (List<Uri>)arrayList);
                this.zza(zzb2);
            } else if (SERVICE_ACTION_INITIALIZE.equals(string2)) {
                this.onInitializeTasks();
            } else {
                Log.e((String)"GcmTaskService", (String)new StringBuilder(37 + String.valueOf(string2).length()).append("Unknown action received ").append(string2).append(", terminating").toString());
            }
            return 2;
        }
        finally {
            this.zzdp(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzhy(String string2) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = !this.zzich.zzaa(string2, this.componentName.getClassName());
            if (bl) {
                String string3 = this.getPackageName();
                Log.w((String)"GcmTaskService", (String)new StringBuilder(44 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).append(": Task already running, won't start another").toString());
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzdp(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.zzicf = n;
            if (!this.zzich.zzhx(this.componentName.getClassName())) {
                this.stopSelf(this.zzicf);
            }
            return;
        }
    }

    @CallSuper
    public IBinder onBind(Intent intent) {
        if (intent == null || !zzq.zzamn() || !SERVICE_ACTION_EXECUTE_TASK.equals(intent.getAction())) {
            return null;
        }
        return this.zzicg.getBinder();
    }

    private final void zza(zzb zzb2) {
        try {
            this.zzais.execute(zzb2);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Log.e((String)"GcmTaskService", (String)"Executor is shutdown. onDestroy was called but main looper had an unprocessed start task message. The task will be retried with backoff delay.", (Throwable)rejectedExecutionException);
            zzb2.zzdq(1);
            return;
        }
    }

    public abstract int onRunTask(TaskParams var1);

    public void onInitializeTasks() {
    }

    final class zzb
    implements Runnable {
        private final String mTag;
        private final Bundle mExtras;
        private final List<Uri> zzick;
        @Nullable
        private final zzd zzicl;
        @Nullable
        private final Messenger mMessenger;
        private /* synthetic */ GcmTaskService zzicj;

        zzb(GcmTaskService gcmTaskService, @NonNull String string2, IBinder iBinder, Bundle bundle, List<Uri> list) {
            IInterface iInterface;
            this.zzicj = gcmTaskService;
            this.mTag = string2;
            IBinder iBinder2 = iBinder;
            this.zzicl = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.gcm.INetworkTaskCallback")) instanceof zzd ? (zzd)iInterface : new zze(iBinder2));
            this.mExtras = bundle;
            this.zzick = list;
            this.mMessenger = null;
        }

        zzb(GcmTaskService gcmTaskService, @NonNull String string2, Messenger messenger, Bundle bundle, List<Uri> list) {
            this.zzicj = gcmTaskService;
            this.mTag = string2;
            this.mMessenger = messenger;
            this.mExtras = bundle;
            this.zzick = list;
            this.zzicl = null;
        }

        @Override
        public final void run() {
            TaskParams taskParams = new TaskParams(this.mTag, this.mExtras, this.zzick);
            int n = this.zzicj.onRunTask(taskParams);
            this.zzdq(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zzdq(int n) {
            Object object = this.zzicj.lock;
            synchronized (object) {
                try {
                    if (this.zzicj.zzich.zzac(this.mTag, this.zzicj.componentName.getClassName())) {
                        return;
                    }
                    if (this.zzauv()) {
                        int n2 = n;
                        zzb zzb2 = this;
                        Message message = Message.obtain();
                        Message.obtain().what = 3;
                        message.arg1 = n2;
                        Bundle bundle = new Bundle();
                        bundle.putParcelable("component", (Parcelable)zzb2.zzicj.componentName);
                        bundle.putString("tag", zzb2.mTag);
                        message.setData(bundle);
                        this.mMessenger.send(message);
                    } else {
                        this.zzicl.zzdr(n);
                    }
                }
                catch (RemoteException remoteException) {
                    String string2 = String.valueOf(this.mTag);
                    Log.e((String)"GcmTaskService", (String)(string2.length() != 0 ? "Error reporting result of operation to scheduler for ".concat(string2) : new String("Error reporting result of operation to scheduler for ")));
                }
                finally {
                    this.zzicj.zzich.zzab(this.mTag, this.zzicj.componentName.getClassName());
                    if (!this.zzauv() && !this.zzicj.zzich.zzhx(this.zzicj.componentName.getClassName())) {
                        this.zzicj.stopSelf(this.zzicj.zzicf);
                    }
                }
                return;
            }
        }

        private final boolean zzauv() {
            return this.mMessenger != null;
        }
    }

    @TargetApi(value=21)
    final class zza
    extends Handler {
        private /* synthetic */ GcmTaskService zzicj;

        zza(GcmTaskService gcmTaskService, Looper looper) {
            this.zzicj = gcmTaskService;
            super(looper);
        }

        public final void handleMessage(Message message) {
            if (!zzx.zzb((Context)this.zzicj, (int)message.sendingUid, (String)"com.google.android.gms")) {
                Log.e((String)"GcmTaskService", (String)"unable to verify presence of Google Play Services");
                return;
            }
            switch (message.what) {
                case 1: {
                    Messenger messenger;
                    Message message2 = message;
                    zza zza2 = this;
                    Bundle bundle = message2.getData();
                    if (!bundle.isEmpty() && (messenger = message2.replyTo) != null) {
                        String string2 = bundle.getString("tag");
                        ArrayList arrayList = bundle.getParcelableArrayList("triggered_uris");
                        if (!zza2.zzicj.zzhy(string2)) {
                            Bundle bundle2 = bundle.getBundle("extras");
                            zzb zzb2 = new zzb(zza2.zzicj, string2, messenger, bundle2, (List<Uri>)arrayList);
                            zza2.zzicj.zza(zzb2);
                        }
                    }
                    return;
                }
                case 2: {
                    Message message3 = message;
                    if (Log.isLoggable((String)"GcmTaskService", (int)3)) {
                        String string3 = String.valueOf(message3);
                        Log.d((String)"GcmTaskService", (String)new StringBuilder(45 + String.valueOf(string3).length()).append("ignoring unimplemented stop message for now: ").append(string3).toString());
                    }
                    return;
                }
                case 4: {
                    this.zzicj.onInitializeTasks();
                    return;
                }
            }
            String string4 = String.valueOf(message);
            Log.e((String)"GcmTaskService", (String)new StringBuilder(31 + String.valueOf(string4).length()).append("Unrecognized message received: ").append(string4).toString());
        }
    }
}

