/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.gcm.zzf;

public class OneoffTask
extends Task {
    private final long zzict;
    private final long zzicu;
    public static final Parcelable.Creator<OneoffTask> CREATOR = new zzf();

    private OneoffTask(Builder builder) {
        super(builder);
        this.zzict = builder.zzicv;
        this.zzicu = builder.zzicw;
    }

    @Deprecated
    private OneoffTask(Parcel parcel) {
        super(parcel);
        this.zzict = parcel.readLong();
        this.zzicu = parcel.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("window_start", this.zzict);
        bundle.putLong("window_end", this.zzicu);
    }

    public long getWindowStart() {
        return this.zzict;
    }

    public long getWindowEnd() {
        return this.zzicu;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeLong(this.zzict);
        parcel.writeLong(this.zzicu);
    }

    public String toString() {
        String string2 = super.toString();
        long l = this.getWindowStart();
        long l2 = this.getWindowEnd();
        return new StringBuilder(64 + String.valueOf(string2).length()).append(string2).append(" windowStart=").append(l).append(" windowEnd=").append(l2).toString();
    }

    /* synthetic */ OneoffTask(Parcel parcel, zzf zzf2) {
        this(parcel);
    }

    /* synthetic */ OneoffTask(Builder builder, zzf zzf2) {
        this(builder);
    }

    public static class Builder
    extends Task.Builder {
        private long zzicv = -1L;
        private long zzicw = -1L;

        public Builder() {
            this.isPersisted = false;
        }

        public Builder setExecutionWindow(long l, long l2) {
            this.zzicv = l;
            this.zzicw = l2;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> clazz) {
            this.gcmTaskService = clazz.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int n) {
            this.requiredNetworkState = n;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean bl) {
            this.requiresCharging = bl;
            return this;
        }

        @Override
        public Builder setTag(String string2) {
            this.tag = string2;
            return this;
        }

        @Override
        @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
        public Builder setPersisted(boolean bl) {
            this.isPersisted = bl;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean bl) {
            this.updateCurrent = bl;
            return this;
        }

        @Override
        public Builder setExtras(Bundle bundle) {
            this.extras = bundle;
            return this;
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzicv == -1L || this.zzicw == -1L) {
                throw new IllegalArgumentException("Must specify an execution window using setExecutionWindow.");
            }
            if (this.zzicv >= this.zzicw) {
                throw new IllegalArgumentException("Window start must be shorter than window end.");
            }
        }

        @Override
        public OneoffTask build() {
            ((Task.Builder)this).checkConditions();
            return new OneoffTask(this, null);
        }
    }
}

