/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.iid.zzaa;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GcmNetworkManager {
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_RESCHEDULE = 1;
    public static final int RESULT_FAILURE = 2;
    private static GcmNetworkManager zza;
    private Context zzb;
    private final PendingIntent zzc;
    private final Map<String, Map<String, Boolean>> zzd = new ArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GcmNetworkManager getInstance(Context context) {
        Class<GcmNetworkManager> clazz = GcmNetworkManager.class;
        synchronized (GcmNetworkManager.class) {
            if (zza == null) {
                zza = new GcmNetworkManager(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    private GcmNetworkManager(Context context) {
        this.zzb = context;
        this.zzc = PendingIntent.getBroadcast((Context)this.zzb, (int)0, (Intent)new Intent().setPackage("com.google.example.invalidpackage"), (int)0);
    }

    @WorkerThread
    public synchronized void schedule(Task task) {
        this.zzc(task.getServiceName());
        Intent intent = this.zza();
        if (intent == null) {
            return;
        }
        Bundle bundle = intent.getExtras();
        bundle.putString("scheduler_action", "SCHEDULE_TASK");
        task.toBundle(bundle);
        intent.putExtras(bundle);
        this.zzb.sendBroadcast(intent);
        Map<String, Boolean> map = this.zzd.get(task.getServiceName());
        if (map != null && map.containsKey(task.getTag())) {
            map.put(task.getTag(), true);
        }
    }

    @WorkerThread
    public void cancelTask(String string2, Class<? extends GcmTaskService> clazz) {
        Class<? extends GcmTaskService> clazz2 = clazz;
        String string3 = string2;
        GcmNetworkManager gcmNetworkManager = this;
        ComponentName componentName = new ComponentName(gcmNetworkManager.zzb, clazz2);
        String string4 = string3;
        GcmNetworkManager gcmNetworkManager2 = gcmNetworkManager;
        GcmNetworkManager.zza(string4);
        gcmNetworkManager2.zzc(componentName.getClassName());
        Intent intent = gcmNetworkManager2.zza();
        if (intent != null) {
            intent.putExtra("scheduler_action", "CANCEL_TASK");
            intent.putExtra("tag", string4);
            intent.putExtra("component", (Parcelable)componentName);
            gcmNetworkManager2.zzb.sendBroadcast(intent);
        }
    }

    @WorkerThread
    public void cancelAllTasks(Class<? extends GcmTaskService> clazz) {
        Class<? extends GcmTaskService> clazz2 = clazz;
        GcmNetworkManager gcmNetworkManager = this;
        ComponentName componentName = new ComponentName(gcmNetworkManager.zzb, clazz2);
        GcmNetworkManager gcmNetworkManager2 = gcmNetworkManager;
        gcmNetworkManager.zzc(componentName.getClassName());
        Intent intent = gcmNetworkManager2.zza();
        if (intent != null) {
            intent.putExtra("scheduler_action", "CANCEL_ALL");
            intent.putExtra("component", (Parcelable)componentName);
            gcmNetworkManager2.zzb.sendBroadcast(intent);
        }
    }

    private final Intent zza() {
        String string2 = zzaa.zzb((Context)this.zzb);
        int n = -1;
        if (string2 != null) {
            n = GoogleCloudMessaging.zza(this.zzb);
        }
        if (string2 == null || n < 5000000) {
            int n2 = n;
            Log.e((String)"GcmNetworkManager", (String)new StringBuilder(91).append("Google Play Services is not available, dropping GcmNetworkManager request. code=").append(n2).toString());
            return null;
        }
        Intent intent = new Intent("com.google.android.gms.gcm.ACTION_SCHEDULE");
        intent.setPackage(string2);
        intent.putExtra("app", (Parcelable)this.zzc);
        intent.putExtra("source", 4);
        intent.putExtra("source_version", 12210000);
        return intent;
    }

    static void zza(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Must provide a valid tag.");
        }
        if (100 < string2.length()) {
            throw new IllegalArgumentException("Tag is larger than max permissible tag length (100)");
        }
    }

    private final boolean zzc(String string2) {
        List list;
        zzbq.zza((Object)string2, (Object)"GcmTaskService must not be null.");
        String string3 = string2;
        Object object = this;
        PackageManager packageManager = ((GcmNetworkManager)object).zzb.getPackageManager();
        if (packageManager == null) {
            list = Collections.emptyList();
        } else {
            String string4 = string3;
            GcmNetworkManager gcmNetworkManager = object;
            list = packageManager.queryIntentServices(string4 != null ? new Intent("com.google.android.gms.gcm.ACTION_TASK_READY").setClassName(gcmNetworkManager.zzb, string4) : new Intent("com.google.android.gms.gcm.ACTION_TASK_READY").setPackage(gcmNetworkManager.zzb.getPackageName()), 0);
        }
        List list2 = list;
        object = list;
        if (list == null ? true : object.isEmpty()) {
            Log.e((String)"GcmNetworkManager", (String)String.valueOf(string2).concat(" is not available. This may cause the task to be lost."));
            return true;
        }
        for (ResolveInfo resolveInfo : list2) {
            if (resolveInfo.serviceInfo == null || !resolveInfo.serviceInfo.enabled) continue;
            return true;
        }
        throw new IllegalArgumentException(new StringBuilder(118 + String.valueOf(string2).length()).append("The GcmTaskService class you provided ").append(string2).append(" does not seem to support receiving com.google.android.gms.gcm.ACTION_TASK_READY").toString());
    }

    @Hide
    final synchronized boolean zza(String string2, String string3) {
        ArrayMap arrayMap = this.zzd.get(string3);
        if (arrayMap == null) {
            arrayMap = new ArrayMap();
            this.zzd.put(string3, (Map<String, Boolean>)arrayMap);
        }
        return arrayMap.put(string2, false) == null;
    }

    @Hide
    final synchronized void zzb(String string2, String string3) {
        Map<String, Boolean> map = this.zzd.get(string3);
        if (map != null && map.remove(string2) != null && map.isEmpty()) {
            this.zzd.remove(string3);
        }
    }

    @Hide
    final synchronized boolean zzc(String string2, String string3) {
        Map<String, Boolean> map = this.zzd.get(string3);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @Hide
    final synchronized boolean zzb(String string2) {
        return this.zzd.containsKey(string2);
    }
}

