/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.CallSuper;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.zzi;

public class Task
implements ReflectedParcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    public static final int EXTRAS_LIMIT_BYTES = 10240;
    private final String zza;
    private final String zzb;
    private final boolean zzc;
    private final boolean zzd;
    private final int zze;
    private final boolean zzf;
    private final boolean zzg;
    private final zzi zzh;
    private final Bundle zzi;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.zza = builder.gcmTaskService;
        this.zzb = builder.tag;
        this.zzc = builder.updateCurrent;
        this.zzd = builder.isPersisted;
        this.zze = builder.requiredNetworkState;
        this.zzf = builder.requiresCharging;
        this.zzg = false;
        this.zzi = builder.extras;
        this.zzh = builder.zza != null ? builder.zza : com.google.android.gms.gcm.zzi.zza;
    }

    @Deprecated
    Task(Parcel parcel) {
        Log.e((String)"Task", (String)"Constructing a Task object using a parcel.");
        this.zza = parcel.readString();
        this.zzb = parcel.readString();
        this.zzc = parcel.readInt() == 1;
        this.zzd = parcel.readInt() == 1;
        this.zze = 2;
        this.zzf = false;
        this.zzg = false;
        this.zzh = com.google.android.gms.gcm.zzi.zza;
        this.zzi = null;
    }

    @Hide
    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.zzb);
        bundle.putBoolean("update_current", this.zzc);
        bundle.putBoolean("persisted", this.zzd);
        bundle.putString("service", this.zza);
        bundle.putInt("requiredNetwork", this.zze);
        bundle.putBoolean("requiresCharging", this.zzf);
        bundle.putBoolean("requiresIdle", false);
        bundle.putBundle("retryStrategy", this.zzh.zza(new Bundle()));
        bundle.putBundle("extras", this.zzi);
    }

    public String getServiceName() {
        return this.zza;
    }

    public String getTag() {
        return this.zzb;
    }

    public boolean isUpdateCurrent() {
        return this.zzc;
    }

    public boolean isPersisted() {
        return this.zzd;
    }

    public int getRequiredNetwork() {
        return this.zze;
    }

    public boolean getRequiresCharging() {
        return this.zzf;
    }

    public Bundle getExtras() {
        return this.zzi;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.zza);
        parcel.writeString(this.zzb);
        parcel.writeInt(this.zzc ? 1 : 0);
        parcel.writeInt(this.zzd ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    @Hide
    public static void zza(Bundle bundle) {
        if (bundle != null) {
            Object object = bundle;
            Parcel parcel = Parcel.obtain();
            object.writeToParcel(parcel, 0);
            int n = parcel.dataSize();
            parcel.recycle();
            int n2 = n;
            if (n2 > 10240) {
                throw new IllegalArgumentException(new StringBuilder(55).append("Extras exceeding maximum size(10240 bytes): ").append(n2).toString());
            }
            for (String string2 : bundle.keySet()) {
                Object object2 = bundle.get(string2);
                object = object2;
                if (object2 instanceof Integer || object instanceof Long || object instanceof Double || object instanceof String || object instanceof Boolean) continue;
                if (object2 instanceof Bundle) {
                    Task.zza((Bundle)object2);
                    continue;
                }
                throw new IllegalArgumentException("Only the following extra parameter types are supported: Integer, Long, Double, String, Boolean, and nested Bundles with the same restrictions.");
            }
        }
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;
        @Hide
        protected zzi zza = com.google.android.gms.gcm.zzi.zza;
        protected Bundle extras;

        public Builder() {
        }

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
        public abstract Builder setPersisted(boolean var1);

        public abstract Builder setExtras(Bundle var1);

        public abstract Task build();

        @CallSuper
        protected void checkConditions() {
            zzbq.zzb((this.gcmTaskService != null ? 1 : 0) != 0, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zza(this.tag);
            zzi zzi2 = this.zza;
            if (zzi2 != null) {
                int n = zzi2.zza();
                if (n != 1 && n != 0) {
                    throw new IllegalArgumentException(new StringBuilder(45).append("Must provide a valid RetryPolicy: ").append(n).toString());
                }
                int n2 = zzi2.zzb();
                int n3 = zzi2.zzc();
                if (n == 0 && n2 < 0) {
                    throw new IllegalArgumentException(new StringBuilder(52).append("InitialBackoffSeconds can't be negative: ").append(n2).toString());
                }
                if (n == 1 && n2 < 10) {
                    throw new IllegalArgumentException("RETRY_POLICY_LINEAR must have an initial backoff at least 10 seconds.");
                }
                if (n3 < n2) {
                    int n4 = zzi2.zzc();
                    throw new IllegalArgumentException(new StringBuilder(77).append("MaximumBackoffSeconds must be greater than InitialBackoffSeconds: ").append(n4).toString());
                }
            }
            if (this.isPersisted) {
                Task.zza(this.extras);
            }
        }
    }
}

