/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.iid.zzh;

public class GcmReceiver
extends WakefulBroadcastReceiver {
    private static boolean zzijq = false;
    private static zzh zzijr;
    private static zzh zzijs;

    public GcmReceiver() {
    }

    public void onReceive(Context context, Intent intent) {
        String string2;
        String string3;
        if (Log.isLoggable((String)"GcmReceiver", (int)3)) {
            Log.d((String)"GcmReceiver", (String)"received new intent");
        }
        intent.setComponent(null);
        intent.setPackage(context.getPackageName());
        if (Build.VERSION.SDK_INT <= 18) {
            intent.removeCategory(context.getPackageName());
        }
        if ("google.com/iid".equals(string3 = intent.getStringExtra("from"))) {
            intent.setAction("com.google.android.gms.iid.InstanceID");
        }
        if ((string2 = intent.getStringExtra("gcm.rawData64")) != null) {
            intent.putExtra("rawData", Base64.decode((String)string2, (int)0));
            intent.removeExtra("gcm.rawData64");
        }
        Context context2 = context;
        if (zzs.isAtLeastO() && context2.getApplicationInfo().targetSdkVersion > 25) {
            if (this.isOrderedBroadcast()) {
                this.setResultCode(-1);
            }
            this.zzaa(context, intent.getAction()).zza(intent, this.goAsync());
            return;
        }
        if ("com.google.android.c2dm.intent.RECEIVE".equals(intent.getAction())) {
            Intent intent2 = intent;
            Context context3 = context;
            this.doStartService(context3, intent2);
        } else {
            this.doStartService(context, intent);
        }
        if (this.isOrderedBroadcast() && this.getResultCode() == 0) {
            this.setResultCode(-1);
        }
    }

    private final synchronized zzh zzaa(Context context, String string2) {
        if ("com.google.android.c2dm.intent.RECEIVE".equals(string2)) {
            if (zzijs == null) {
                zzijs = new zzh(context, string2);
            }
            return zzijs;
        }
        if (zzijr == null) {
            zzijr = new zzh(context, string2);
        }
        return zzijr;
    }

    private final void doStartService(Context context, Intent intent) {
        if (this.isOrderedBroadcast()) {
            this.setResultCode(500);
        }
        Intent intent2 = intent;
        Context context2 = context;
        ResolveInfo resolveInfo = context2.getPackageManager().resolveService(intent2, 0);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Log.e((String)"GcmReceiver", (String)"Failed to resolve target intent service, skipping classname enforcement");
        } else {
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (!context2.getPackageName().equals(serviceInfo.packageName) || serviceInfo.name == null) {
                String string2 = serviceInfo.packageName;
                String string3 = serviceInfo.name;
                Log.e((String)"GcmReceiver", (String)new StringBuilder(94 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Error resolving target intent service, skipping classname enforcement. Resolved service was: ").append(string2).append("/").append(string3).toString());
            } else {
                String string4;
                String string5 = serviceInfo.name;
                if (string5.startsWith(".")) {
                    String string6 = String.valueOf(context2.getPackageName());
                    String string7 = String.valueOf(string5);
                    string4 = string7.length() != 0 ? string6.concat(string7) : new String(string6);
                } else {
                    string4 = string5 = string5;
                }
                if (Log.isLoggable((String)"GcmReceiver", (int)3)) {
                    String string8 = String.valueOf(string5);
                    Log.d((String)"GcmReceiver", (String)(string8.length() != 0 ? "Restricting intent to a specific service: ".concat(string8) : new String("Restricting intent to a specific service: ")));
                }
                intent2.setClassName(context2.getPackageName(), string5);
            }
        }
        try {
            ComponentName componentName;
            if (context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0) {
                componentName = GcmReceiver.startWakefulService((Context)context, (Intent)intent);
            } else {
                componentName = context.startService(intent);
                Log.d((String)"GcmReceiver", (String)"Missing wake lock permission, service start may be delayed");
            }
            if (componentName == null) {
                Log.e((String)"GcmReceiver", (String)"Error while delivering the message: ServiceIntent not found.");
                if (this.isOrderedBroadcast()) {
                    this.setResultCode(404);
                    return;
                }
            } else if (this.isOrderedBroadcast()) {
                this.setResultCode(-1);
            }
            return;
        }
        catch (SecurityException securityException) {
            Log.e((String)"GcmReceiver", (String)"Error while delivering the message to the serviceIntent", (Throwable)securityException);
            if (this.isOrderedBroadcast()) {
                this.setResultCode(401);
            }
            return;
        }
    }
}

