/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.gcm.zzh;

public class PeriodicTask
extends Task {
    protected long mIntervalInSeconds = -1L;
    protected long mFlexInSeconds = -1L;
    public static final Parcelable.Creator<PeriodicTask> CREATOR = new zzh();

    private PeriodicTask(Builder builder) {
        super(builder);
        this.mIntervalInSeconds = builder.zzikl;
        this.mFlexInSeconds = Math.min(builder.zzikm, this.mIntervalInSeconds);
    }

    @Deprecated
    private PeriodicTask(Parcel parcel) {
        super(parcel);
        this.mIntervalInSeconds = parcel.readLong();
        this.mFlexInSeconds = Math.min(parcel.readLong(), this.mIntervalInSeconds);
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("period", this.mIntervalInSeconds);
        bundle.putLong("period_flex", this.mFlexInSeconds);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeLong(this.mIntervalInSeconds);
        parcel.writeLong(this.mFlexInSeconds);
    }

    public long getPeriod() {
        return this.mIntervalInSeconds;
    }

    public long getFlex() {
        return this.mFlexInSeconds;
    }

    public String toString() {
        String string2 = super.toString();
        long l = this.getPeriod();
        long l2 = this.getFlex();
        return new StringBuilder(54 + String.valueOf(string2).length()).append(string2).append(" period=").append(l).append(" flex=").append(l2).toString();
    }

    /* synthetic */ PeriodicTask(Parcel parcel, zzh zzh2) {
        this(parcel);
    }

    /* synthetic */ PeriodicTask(Builder builder, zzh zzh2) {
        this(builder);
    }

    public static class Builder
    extends Task.Builder {
        private long zzikl = -1L;
        private long zzikm = -1L;

        public Builder() {
            this.isPersisted = true;
        }

        public Builder setPeriod(long l) {
            this.zzikl = l;
            return this;
        }

        public Builder setFlex(long l) {
            this.zzikm = l;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> clazz) {
            this.gcmTaskService = clazz.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int n) {
            this.requiredNetworkState = n;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean bl) {
            this.requiresCharging = bl;
            return this;
        }

        @Override
        public Builder setTag(String string2) {
            this.tag = string2;
            return this;
        }

        @Override
        @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
        public Builder setPersisted(boolean bl) {
            this.isPersisted = bl;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean bl) {
            this.updateCurrent = bl;
            return this;
        }

        @Override
        public Builder setExtras(Bundle bundle) {
            this.extras = bundle;
            return this;
        }

        @Override
        public PeriodicTask build() {
            ((Task.Builder)this).checkConditions();
            return new PeriodicTask(this, null);
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzikl == -1L) {
                throw new IllegalArgumentException("Must call setPeriod(long) to establish an execution interval for this periodic task.");
            }
            if (this.zzikl <= 0L) {
                long l = this.zzikl;
                throw new IllegalArgumentException(new StringBuilder(66).append("Period set cannot be less than or equal to 0: ").append(l).toString());
            }
            if (this.zzikm == -1L) {
                this.zzikm = (long)((float)this.zzikl * 0.1f);
                return;
            }
            if (this.zzikm > this.zzikl) {
                this.zzikm = this.zzikl;
            }
        }
    }
}

