/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.iid.zzk;

@Deprecated
public class GcmReceiver
extends WakefulBroadcastReceiver {
    private static boolean zzr = false;
    private static zzk zzs;
    private static zzk zzt;

    public GcmReceiver() {
    }

    public void onReceive(Context context, Intent intent) {
        int n;
        int n2;
        boolean bl;
        String string2;
        String string3;
        if (Log.isLoggable((String)"GcmReceiver", (int)3)) {
            Log.d((String)"GcmReceiver", (String)"received new intent");
        }
        intent.setComponent(null);
        intent.setPackage(context.getPackageName());
        if (Build.VERSION.SDK_INT <= 18) {
            intent.removeCategory(context.getPackageName());
        }
        if ("google.com/iid".equals(string3 = intent.getStringExtra("from"))) {
            intent.setAction("com.google.android.gms.iid.InstanceID");
        }
        if ((string2 = intent.getStringExtra("gcm.rawData64")) != null) {
            intent.putExtra("rawData", Base64.decode((String)string2, (int)0));
            intent.removeExtra("gcm.rawData64");
        }
        if (this.isOrderedBroadcast()) {
            this.setResultCode(500);
        }
        Intent intent2 = intent;
        Context context2 = context;
        GcmReceiver gcmReceiver = this;
        boolean bl2 = PlatformVersion.isAtLeastO() && context2.getApplicationInfo().targetSdkVersion >= 26;
        boolean bl3 = bl = (intent2.getFlags() & 0x10000000) != 0;
        if (bl2 && !bl) {
            n2 = gcmReceiver.zzd(context2, intent2);
        } else {
            int n3;
            if ("com.google.android.c2dm.intent.RECEIVE".equals(intent2.getAction())) {
                Intent intent3 = intent2;
                Context context3 = context2;
                n3 = GcmReceiver.zze(context3, intent3);
            } else {
                n3 = GcmReceiver.zze(context2, intent2);
            }
            if (PlatformVersion.isAtLeastO() && n3 == 402) {
                gcmReceiver.zzd(context2, intent2);
                n2 = 403;
            } else {
                n2 = n = n3;
            }
        }
        if (this.isOrderedBroadcast()) {
            this.setResultCode(n);
        }
    }

    private final int zzd(Context context, Intent intent) {
        if (Log.isLoggable((String)"GcmReceiver", (int)3)) {
            Log.d((String)"GcmReceiver", (String)"Binding to service");
        }
        if (this.isOrderedBroadcast()) {
            this.setResultCode(-1);
        }
        this.zzd(context, intent.getAction()).zzd(intent, this.goAsync());
        return -1;
    }

    private final synchronized zzk zzd(Context context, String string2) {
        if ("com.google.android.c2dm.intent.RECEIVE".equals(string2)) {
            if (zzt == null) {
                zzt = new zzk(context, string2);
            }
            return zzt;
        }
        if (zzs == null) {
            zzs = new zzk(context, string2);
        }
        return zzs;
    }

    private static int zze(Context context, Intent intent) {
        if (Log.isLoggable((String)"GcmReceiver", (int)3)) {
            Log.d((String)"GcmReceiver", (String)"Starting service");
        }
        Intent intent2 = intent;
        Context context2 = context;
        ResolveInfo resolveInfo = context2.getPackageManager().resolveService(intent2, 0);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Log.e((String)"GcmReceiver", (String)"Failed to resolve target intent service, skipping classname enforcement");
        } else {
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (!context2.getPackageName().equals(serviceInfo.packageName) || serviceInfo.name == null) {
                String string2 = serviceInfo.packageName;
                String string3 = serviceInfo.name;
                Log.e((String)"GcmReceiver", (String)new StringBuilder(94 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Error resolving target intent service, skipping classname enforcement. Resolved service was: ").append(string2).append("/").append(string3).toString());
            } else {
                String string4;
                String string5 = serviceInfo.name;
                if (string5.startsWith(".")) {
                    String string6 = String.valueOf(context2.getPackageName());
                    String string7 = String.valueOf(string5);
                    string4 = string7.length() != 0 ? string6.concat(string7) : new String(string6);
                } else {
                    string4 = string5 = string5;
                }
                if (Log.isLoggable((String)"GcmReceiver", (int)3)) {
                    String string8 = String.valueOf(string5);
                    Log.d((String)"GcmReceiver", (String)(string8.length() != 0 ? "Restricting intent to a specific service: ".concat(string8) : new String("Restricting intent to a specific service: ")));
                }
                intent2.setClassName(context2.getPackageName(), string5);
            }
        }
        try {
            ComponentName componentName;
            if (context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0) {
                componentName = GcmReceiver.startWakefulService((Context)context, (Intent)intent);
            } else {
                componentName = context.startService(intent);
                Log.d((String)"GcmReceiver", (String)"Missing wake lock permission, service start may be delayed");
            }
            if (componentName == null) {
                Log.e((String)"GcmReceiver", (String)"Error while delivering the message: ServiceIntent not found.");
                return 404;
            }
            return -1;
        }
        catch (SecurityException securityException) {
            Log.e((String)"GcmReceiver", (String)"Error while delivering the message to the serviceIntent", (Throwable)securityException);
            return 401;
        }
        catch (IllegalStateException illegalStateException) {
            String string9 = String.valueOf(illegalStateException);
            Log.e((String)"GcmReceiver", (String)new StringBuilder(45 + String.valueOf(string9).length()).append("Failed to start service while in background: ").append(string9).toString());
            return 402;
        }
    }
}

