/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.annotation.TargetApi;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.PendingCallback;
import com.google.android.gms.gcm.TaskParams;
import com.google.android.gms.gcm.zzg;
import com.google.android.gms.gcm.zzh;
import com.google.android.gms.gcm.zzp;
import com.google.android.gms.internal.gcm.zzj;
import com.google.android.gms.internal.gcm.zzl;
import com.google.android.gms.internal.gcm.zzm;
import com.google.android.gms.internal.gcm.zzq;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import javax.annotation.concurrent.GuardedBy;

public abstract class GcmTaskService
extends Service {
    public static final String SERVICE_PERMISSION = "com.google.android.gms.permission.BIND_NETWORK_TASK_SERVICE";
    public static final String SERVICE_ACTION_EXECUTE_TASK = "com.google.android.gms.gcm.ACTION_TASK_READY";
    public static final String SERVICE_ACTION_INITIALIZE = "com.google.android.gms.gcm.SERVICE_ACTION_INITIALIZE";
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private int zzu;
    private ExecutorService zzv;
    private Messenger zzw;
    private ComponentName componentName;
    private GcmNetworkManager zzx;
    private zzl zzg;

    public GcmTaskService() {
    }

    @CallSuper
    public void onCreate() {
        super.onCreate();
        this.zzx = GcmNetworkManager.getInstance((Context)this);
        GcmTaskService gcmTaskService = this;
        this.zzv = com.google.android.gms.internal.gcm.zzg.zzaa().zzd(10, (ThreadFactory)new com.google.android.gms.gcm.zze(gcmTaskService), 10);
        this.zzw = new Messenger((Handler)new zzd(Looper.getMainLooper()));
        this.componentName = new ComponentName((Context)this, ((Object)((Object)this)).getClass());
        zzm.zzab();
        ((Object)((Object)this)).getClass();
        this.zzg = zzm.zzdk;
    }

    @CallSuper
    public void onDestroy() {
        super.onDestroy();
        List<Runnable> list = this.zzv.shutdownNow();
        if (!list.isEmpty()) {
            int n = list.size();
            Log.e((String)"GcmTaskService", (String)new StringBuilder(79).append("Shutting down, but not all tasks are finished executing. Remaining: ").append(n).toString());
        }
    }

    @CallSuper
    public int onStartCommand(Intent intent, int n, int n2) {
        if (intent == null) {
            this.zzd(n2);
            return 2;
        }
        try {
            intent.setExtrasClassLoader(PendingCallback.class.getClassLoader());
            String string2 = intent.getAction();
            if (SERVICE_ACTION_EXECUTE_TASK.equals(string2)) {
                String string3 = intent.getStringExtra("tag");
                Parcelable parcelable = intent.getParcelableExtra("callback");
                Bundle bundle = intent.getBundleExtra("extras");
                ArrayList arrayList = intent.getParcelableArrayListExtra("triggered_uris");
                long l = intent.getLongExtra("max_exec_duration", 180L);
                if (!(parcelable instanceof PendingCallback)) {
                    String string4 = this.getPackageName();
                    Log.e((String)"GcmTaskService", (String)new StringBuilder(47 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append(" ").append(string3).append(": Could not process request, invalid callback.").toString());
                    return 2;
                }
                if (this.zzg(string3)) {
                    return 2;
                }
                IBinder iBinder = ((PendingCallback)parcelable).zzan;
                zze zze2 = new zze(string3, iBinder, bundle, l, (List<Uri>)arrayList);
                this.zzd(zze2);
            } else if (SERVICE_ACTION_INITIALIZE.equals(string2)) {
                this.onInitializeTasks();
            } else {
                Log.e((String)"GcmTaskService", (String)new StringBuilder(37 + String.valueOf(string2).length()).append("Unknown action received ").append(string2).append(", terminating").toString());
            }
            return 2;
        }
        finally {
            this.zzd(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzg(String string2) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = !this.zzx.zzd(string2, this.componentName.getClassName());
            if (bl) {
                String string3 = this.getPackageName();
                Log.w((String)"GcmTaskService", (String)new StringBuilder(44 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).append(": Task already running, won't start another").toString());
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzd(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.zzu = n;
            if (!this.zzx.zzf(this.componentName.getClassName())) {
                this.stopSelf(this.zzu);
            }
            return;
        }
    }

    @CallSuper
    public IBinder onBind(Intent intent) {
        if (intent == null || !PlatformVersion.isAtLeastLollipop() || !SERVICE_ACTION_EXECUTE_TASK.equals(intent.getAction())) {
            return null;
        }
        return this.zzw.getBinder();
    }

    private final void zzd(zze zze2) {
        try {
            this.zzv.execute(zze2);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Log.e((String)"GcmTaskService", (String)"Executor is shutdown. onDestroy was called but main looper had an unprocessed start task message. The task will be retried with backoff delay.", (Throwable)rejectedExecutionException);
            zze2.zze(1);
            return;
        }
    }

    public abstract int onRunTask(TaskParams var1);

    public void onInitializeTasks() {
    }

    final class zze
    implements Runnable {
        private final String tag;
        private final Bundle extras;
        private final List<Uri> zzaa;
        private final long zzab;
        @Nullable
        private final zzg zzac;
        @Nullable
        private final Messenger zzad;

        zze(@NonNull String string2, IBinder iBinder, Bundle bundle, long l, List<Uri> list) {
            IInterface iInterface;
            this.tag = string2;
            IBinder iBinder2 = iBinder;
            this.zzac = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.gcm.INetworkTaskCallback")) instanceof zzg ? (zzg)iInterface : new zzh(iBinder2));
            this.extras = bundle;
            this.zzab = l;
            this.zzaa = list;
            this.zzad = null;
        }

        zze(@NonNull String string2, Messenger messenger, Bundle bundle, long l, List<Uri> list) {
            this.tag = string2;
            this.zzad = messenger;
            this.extras = bundle;
            this.zzab = l;
            this.zzaa = list;
            this.zzac = null;
        }

        @Override
        public final void run() {
            String string2 = String.valueOf("nts:client:onRunTask:");
            String string3 = String.valueOf(this.tag);
            zzp zzp2 = new zzp(string3.length() != 0 ? string2.concat(string3) : new String(string2));
            Throwable throwable = null;
            try {
                TaskParams taskParams = new TaskParams(this.tag, this.extras, this.zzab, this.zzaa);
                GcmTaskService.this.zzg.zzd("onRunTask", com.google.android.gms.internal.gcm.zzp.zzdo);
                int n = GcmTaskService.this.onRunTask(taskParams);
                this.zze(n);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    zze.zzd(throwable, zzp2);
                    throw throwable4;
                }
            }
            zze.zzd(null, zzp2);
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zze(int n) {
            Object object = GcmTaskService.this.lock;
            synchronized (object) {
                try {
                    if (GcmTaskService.this.zzx.zzf(this.tag, GcmTaskService.this.componentName.getClassName())) {
                        return;
                    }
                    if (this.zzg()) {
                        int n2 = n;
                        zze zze2 = this;
                        Message message = Message.obtain();
                        Message.obtain().what = 3;
                        message.arg1 = n2;
                        Bundle bundle = new Bundle();
                        bundle.putParcelable("component", (Parcelable)zze2.GcmTaskService.this.componentName);
                        bundle.putString("tag", zze2.tag);
                        message.setData(bundle);
                        this.zzad.send(message);
                    } else {
                        this.zzac.zzf(n);
                    }
                }
                catch (RemoteException remoteException) {
                    String string2 = String.valueOf(this.tag);
                    Log.e((String)"GcmTaskService", (String)(string2.length() != 0 ? "Error reporting result of operation to scheduler for ".concat(string2) : new String("Error reporting result of operation to scheduler for ")));
                }
                finally {
                    GcmTaskService.this.zzx.zze(this.tag, GcmTaskService.this.componentName.getClassName());
                    if (!this.zzg() && !GcmTaskService.this.zzx.zzf(GcmTaskService.this.componentName.getClassName())) {
                        GcmTaskService.this.stopSelf(GcmTaskService.this.zzu);
                    }
                }
                return;
            }
        }

        private final boolean zzg() {
            return this.zzad != null;
        }

        private static /* synthetic */ void zzd(Throwable throwable, zzp zzp2) {
            if (throwable != null) {
                try {
                    zzp2.close();
                    return;
                }
                catch (Throwable throwable2) {
                    zzq.zzd((Throwable)throwable, (Throwable)throwable2);
                    return;
                }
            }
            zzp2.close();
        }
    }

    @TargetApi(value=21)
    @VisibleForTesting
    final class zzd
    extends zzj {
        zzd(Looper looper) {
            super(looper);
        }

        public final void handleMessage(Message message) {
            if (!UidVerifier.uidHasPackageName((Context)GcmTaskService.this, (int)message.sendingUid, (String)"com.google.android.gms")) {
                Log.e((String)"GcmTaskService", (String)"unable to verify presence of Google Play Services");
                return;
            }
            switch (message.what) {
                case 1: {
                    Messenger messenger;
                    Message message2 = message;
                    zzd zzd2 = this;
                    Bundle bundle = message2.getData();
                    if (!bundle.isEmpty() && (messenger = message2.replyTo) != null) {
                        String string2 = bundle.getString("tag");
                        ArrayList arrayList = bundle.getParcelableArrayList("triggered_uris");
                        long l = bundle.getLong("max_exec_duration", 180L);
                        if (!zzd2.GcmTaskService.this.zzg(string2)) {
                            Bundle bundle2 = bundle.getBundle("extras");
                            zze zze2 = new zze(string2, messenger, bundle2, l, (List<Uri>)arrayList);
                            zzd2.GcmTaskService.this.zzd(zze2);
                        }
                    }
                    return;
                }
                case 2: {
                    Message message3 = message;
                    if (Log.isLoggable((String)"GcmTaskService", (int)3)) {
                        String string3 = String.valueOf(message3);
                        Log.d((String)"GcmTaskService", (String)new StringBuilder(45 + String.valueOf(string3).length()).append("ignoring unimplemented stop message for now: ").append(string3).toString());
                    }
                    return;
                }
                case 4: {
                    GcmTaskService.this.onInitializeTasks();
                    return;
                }
            }
            String string4 = String.valueOf(message);
            Log.e((String)"GcmTaskService", (String)new StringBuilder(31 + String.valueOf(string4).length()).append("Unrecognized message received: ").append(string4).toString());
        }
    }
}

