/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.google.android.gms.gcm.GcmReceiver;
import com.google.android.gms.gcm.zza;

public abstract class GcmListenerService
extends Service {
    private final Object zzpd = new Object();
    private int zzaCe;
    private int zzaCf = 0;

    public void onMessageReceived(String from, Bundle data) {
    }

    public void onDeletedMessages() {
    }

    public void onMessageSent(String msgId) {
    }

    public void onSendError(String msgId, String error) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int onStartCommand(final Intent intent, int flags, int startId) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzaCe = startId;
            ++this.zzaCf;
        }
        if (Build.VERSION.SDK_INT >= 11) {
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    GcmListenerService.this.zzk(intent);
                }
            });
        } else {
            new AsyncTask<Void, Void, Void>(){

                protected Void zzb(Void ... voidArray) {
                    GcmListenerService.this.zzk(intent);
                    return null;
                }

                protected /* synthetic */ Object doInBackground(Object[] x0) {
                    return this.zzb((Void[])x0);
                }
            }.execute((Object[])new Void[0]);
        }
        return 3;
    }

    public final IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzk(Intent intent) {
        try {
            if (!"com.google.android.c2dm.intent.RECEIVE".equals(intent.getAction())) {
                return;
            }
            String string = intent.getStringExtra("message_type");
            if (string == null) {
                string = "gcm";
            }
            switch (string) {
                case "gcm": {
                    this.zzt(intent.getExtras());
                    break;
                }
                case "deleted_messages": {
                    this.onDeletedMessages();
                    break;
                }
                case "send_event": {
                    this.onMessageSent(intent.getStringExtra("google.message_id"));
                    break;
                }
                case "send_error": {
                    this.onSendError(intent.getStringExtra("google.message_id"), intent.getStringExtra("error"));
                    break;
                }
                default: {
                    Log.w((String)"GcmListenerService", (String)("Received message with unknown type: " + string));
                }
            }
            Object object = this.zzpd;
            synchronized (object) {
                --this.zzaCf;
                if (this.zzaCf == 0) {
                    this.zzgA(this.zzaCe);
                }
            }
        }
        finally {
            GcmReceiver.completeWakefulIntent((Intent)intent);
        }
    }

    private void zzt(Bundle bundle) {
        bundle.remove("message_type");
        bundle.remove("android.support.content.wakelockid");
        if (zza.zzu(bundle)) {
            zza.zzaz((Context)this).zzv(bundle);
            return;
        }
        String string = bundle.getString("from");
        bundle.remove("from");
        this.onMessageReceived(string, bundle);
    }

    boolean zzgA(int n) {
        return this.stopSelfResult(n);
    }
}

