/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;

public class PeriodicTask
extends Task {
    protected long mIntervalInSeconds = -1L;
    protected long mFlexInSeconds = -1L;
    public static final Parcelable.Creator<PeriodicTask> CREATOR = new Parcelable.Creator<PeriodicTask>(){

        public PeriodicTask zzeK(Parcel parcel) {
            return new PeriodicTask(parcel);
        }

        public PeriodicTask[] zzhh(int n) {
            return new PeriodicTask[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.zzhh(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzeK(parcel);
        }
    };

    private PeriodicTask(Builder builder) {
        super(builder);
        this.mIntervalInSeconds = builder.zzaMa;
        this.mFlexInSeconds = Math.min(builder.zzaMb, this.mIntervalInSeconds);
    }

    @Deprecated
    private PeriodicTask(Parcel in) {
        super(in);
        this.mIntervalInSeconds = in.readLong();
        this.mFlexInSeconds = Math.min(in.readLong(), this.mIntervalInSeconds);
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("period", this.mIntervalInSeconds);
        bundle.putLong("period_flex", this.mFlexInSeconds);
    }

    public long getPeriod() {
        return this.mIntervalInSeconds;
    }

    public long getFlex() {
        return this.mFlexInSeconds;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        super.writeToParcel(parcel, flags);
        parcel.writeLong(this.mIntervalInSeconds);
        parcel.writeLong(this.mFlexInSeconds);
    }

    public String toString() {
        return super.toString() + " " + "period=" + this.getPeriod() + " " + "flex=" + this.getFlex();
    }

    public static class Builder
    extends Task.Builder {
        private long zzaMa = -1L;
        private long zzaMb = -1L;

        public Builder() {
            this.isPersisted = true;
        }

        public Builder setPeriod(long periodInSeconds) {
            this.zzaMa = periodInSeconds;
            return this;
        }

        public Builder setFlex(long flexInSeconds) {
            this.zzaMb = flexInSeconds;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> gcmTaskService) {
            this.gcmTaskService = gcmTaskService.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int requiredNetworkState) {
            this.requiredNetworkState = requiredNetworkState;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean requiresCharging) {
            this.requiresCharging = requiresCharging;
            return this;
        }

        @Override
        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public Builder setPersisted(boolean isPersisted) {
            this.isPersisted = isPersisted;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean updateCurrent) {
            this.updateCurrent = updateCurrent;
            return this;
        }

        @Override
        public Builder setExtras(Bundle extras) {
            this.extras = extras;
            return this;
        }

        @Override
        public PeriodicTask build() {
            this.checkConditions();
            return new PeriodicTask(this);
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzaMa == -1L) {
                throw new IllegalArgumentException("Must call setPeriod(long) to establish an execution interval for this periodic task.");
            }
            if (this.zzaMa <= 0L) {
                throw new IllegalArgumentException("Period set cannot be less or equal to 0: " + this.zzaMa);
            }
            if (this.zzaMb == -1L) {
                this.zzaMb = (long)((float)this.zzaMa * 0.1f);
            } else if (this.zzaMb > this.zzaMa) {
                this.zzaMb = this.zzaMa;
            }
        }
    }
}

