/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.zzd;

public abstract class Task
implements Parcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    public static final int EXTRAS_LIMIT_BYTES = 10240;
    private final String zzaMh;
    private final String mTag;
    private final boolean zzaMi;
    private final boolean zzaMj;
    private final int zzaMk;
    private final boolean zzaMl;
    private final zzd zzaMm;
    private final Bundle mExtras;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.zzaMh = builder.gcmTaskService;
        this.mTag = builder.tag;
        this.zzaMi = builder.updateCurrent;
        this.zzaMj = builder.isPersisted;
        this.zzaMk = builder.requiredNetworkState;
        this.zzaMl = builder.requiresCharging;
        this.zzaMm = builder.zzaMn;
        this.mExtras = builder.extras;
    }

    @Deprecated
    Task(Parcel in) {
        Log.e((String)"Task", (String)"Constructing a Task object using a parcel.");
        this.zzaMh = in.readString();
        this.mTag = in.readString();
        this.zzaMi = in.readInt() == 1;
        this.zzaMj = in.readInt() == 1;
        this.zzaMk = 2;
        this.zzaMl = false;
        this.zzaMm = zzd.zzaMc;
        this.mExtras = null;
    }

    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.mTag);
        bundle.putBoolean("update_current", this.zzaMi);
        bundle.putBoolean("persisted", this.zzaMj);
        bundle.putString("service", this.zzaMh);
        bundle.putInt("requiredNetwork", this.zzaMk);
        bundle.putBoolean("requiresCharging", this.zzaMl);
        bundle.putBundle("retryStrategy", this.zzaMm.zzF(new Bundle()));
        bundle.putBundle("extras", this.mExtras);
    }

    public String getServiceName() {
        return this.zzaMh;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean isUpdateCurrent() {
        return this.zzaMi;
    }

    public boolean isPersisted() {
        return this.zzaMj;
    }

    public int getRequiredNetwork() {
        return this.zzaMk;
    }

    public boolean getRequiresCharging() {
        return this.zzaMl;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.zzaMh);
        parcel.writeString(this.mTag);
        parcel.writeInt(this.zzaMi ? 1 : 0);
        parcel.writeInt(this.zzaMj ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static void zza(zzd zzd2) {
        if (zzd2 != null) {
            int n = zzd2.zzym();
            if (n != 1 && n != 0) {
                throw new IllegalArgumentException("Must provide a valid RetryPolicy: " + n);
            }
            int n2 = zzd2.zzyn();
            int n3 = zzd2.zzyo();
            if (n == 0 && n2 < 0) {
                throw new IllegalArgumentException("InitialBackoffSeconds can't be negative: " + n2);
            }
            if (n == 1 && n2 < 10) {
                throw new IllegalArgumentException("RETRY_POLICY_LINEAR must have an initial backoff at least 10 seconds.");
            }
            if (n3 < n2) {
                throw new IllegalArgumentException("MaximumBackoffSeconds must be greater than InitialBackoffSeconds: " + zzd2.zzyo());
            }
        }
    }

    public static void zzG(Bundle bundle) {
        if (bundle != null) {
            Parcel parcel = Parcel.obtain();
            bundle.writeToParcel(parcel, 0);
            int n = parcel.dataSize();
            if (n > 10240) {
                parcel.recycle();
                throw new IllegalArgumentException("Extras exceeding maximum size(10240 bytes): " + n);
            }
            parcel.recycle();
            for (String string : bundle.keySet()) {
                if (Task.zzD(bundle.get(string))) continue;
                throw new IllegalArgumentException("Only the following extra parameter types are supported: Integer, Long, Double, String, and Boolean. ");
            }
        }
    }

    private static boolean zzD(Object object) {
        return object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof String || object instanceof Boolean;
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;
        protected zzd zzaMn = zzd.zzaMc;
        protected Bundle extras;

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        public abstract Builder setPersisted(boolean var1);

        public abstract Builder setExtras(Bundle var1);

        public abstract Task build();

        protected void checkConditions() {
            zzx.zzb((this.gcmTaskService != null ? 1 : 0) != 0, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zzdT(this.tag);
            Task.zza(this.zzaMn);
            if (this.isPersisted) {
                Task.zzG(this.extras);
            }
        }
    }
}

