/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.gcm.GcmReceiver;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.MessengerCompat;
import com.google.android.gms.iid.zzc;
import com.google.android.gms.iid.zzd;
import java.io.IOException;

public class InstanceIDListenerService
extends Service {
    static String ACTION = "action";
    MessengerCompat zzaMW = new MessengerCompat(new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            InstanceIDListenerService.this.zza(msg, MessengerCompat.zzc(msg));
        }
    });
    BroadcastReceiver zzaMX = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                String string = intent.getStringExtra("registration_id");
                Log.d((String)"InstanceID", (String)("Received GSF callback using dynamic receiver: " + intent.getExtras()));
            }
            InstanceIDListenerService.this.zzp(intent);
            InstanceIDListenerService.this.stop();
        }
    };
    private static String zzaMY = "google.com/iid";
    private static String zzaMZ = "CMD";
    private static String zzaLH = "gcm.googleapis.com/refresh";
    int zzaNa;
    int zzaNb;

    public void zzp(Intent intent) {
        Object object;
        String string = intent.getStringExtra("subtype");
        InstanceID instanceID = null;
        if (string == null) {
            instanceID = InstanceID.getInstance((Context)this);
        } else {
            object = new Bundle();
            object.putString("subtype", string);
            instanceID = InstanceID.zza((Context)this, object);
        }
        object = intent.getStringExtra(zzaMZ);
        if (null != intent.getStringExtra("error") || null != intent.getStringExtra("registration_id")) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                Log.d((String)"InstanceID", (String)("Register result in service " + string));
            }
            instanceID.zzyC().zzw(intent);
            return;
        }
        if (Log.isLoggable((String)"InstanceID", (int)3)) {
            Log.d((String)"InstanceID", (String)("Service command " + string + " " + (String)object + " " + intent.getExtras()));
        }
        if (null != intent.getStringExtra("unregistered")) {
            instanceID.zzyB().zzef(string == null ? "" : string);
            instanceID.zzyC().zzw(intent);
            return;
        }
        if (zzaLH.equals(intent.getStringExtra("from"))) {
            instanceID.zzyB().zzef(string);
            this.zzal(false);
            return;
        }
        if ("RST".equals(object)) {
            instanceID.zzyA();
            this.zzal(true);
        } else if ("RST_FULL".equals(object)) {
            if (!instanceID.zzyB().isEmpty()) {
                instanceID.zzyB().zzyG();
                this.zzal(true);
            }
        } else if ("SYNC".equals(object)) {
            instanceID.zzyB().zzef(string);
            this.zzal(false);
        } else if ("PING".equals(object)) {
            try {
                GoogleCloudMessaging.getInstance((Context)this).send(zzaMY, zzc.zzyF(), 0L, intent.getExtras());
            }
            catch (IOException iOException) {
                Log.w((String)"InstanceID", (String)"Failed to send ping response");
            }
        }
    }

    static void zza(Context context, zzd zzd2) {
        zzd2.zzyG();
        Intent intent = new Intent("com.google.android.gms.iid.InstanceID");
        intent.putExtra(zzaMZ, "RST");
        intent.setPackage(context.getPackageName());
        context.startService(intent);
    }

    static void zzaM(Context context) {
        Intent intent = new Intent("com.google.android.gms.iid.InstanceID");
        intent.setPackage(context.getPackageName());
        intent.putExtra(zzaMZ, "SYNC");
        context.startService(intent);
    }

    private void zza(Message message, int n) {
        zzc.zzaN((Context)this);
        PackageManager packageManager = this.getPackageManager();
        if (n != zzc.zzaNi && n != zzc.zzaNh) {
            Log.w((String)"InstanceID", (String)("Message from unexpected caller " + n + " mine=" + zzc.zzaNh + " appid=" + zzc.zzaNi));
            return;
        }
        this.zzp((Intent)message.obj);
    }

    public void onCreate() {
        IntentFilter intentFilter = new IntentFilter("com.google.android.c2dm.intent.REGISTRATION");
        intentFilter.addCategory(this.getPackageName());
        this.registerReceiver(this.zzaMX, intentFilter, "com.google.android.c2dm.permission.RECEIVE", null);
    }

    public void onDestroy() {
        this.unregisterReceiver(this.zzaMX);
    }

    public IBinder onBind(Intent intent) {
        if (intent != null && "com.google.android.gms.iid.InstanceID".equals(intent.getAction())) {
            return this.zzaMW.getBinder();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        InstanceIDListenerService instanceIDListenerService = this;
        synchronized (instanceIDListenerService) {
            --this.zzaNa;
            if (this.zzaNa == 0) {
                this.stopSelf(this.zzaNb);
            }
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                Log.d((String)"InstanceID", (String)("Stop " + this.zzaNa + " " + this.zzaNb));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzhl(int n) {
        InstanceIDListenerService instanceIDListenerService = this;
        synchronized (instanceIDListenerService) {
            ++this.zzaNa;
            if (n > this.zzaNb) {
                this.zzaNb = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int flags, int startId) {
        this.zzhl(startId);
        if (intent == null) {
            this.stop();
            return 2;
        }
        try {
            String string = intent.getAction();
            if ("com.google.android.gms.iid.InstanceID".equals(string)) {
                Intent intent2;
                if (Build.VERSION.SDK_INT <= 18 && (intent2 = (Intent)intent.getParcelableExtra("GSF")) != null) {
                    this.startService(intent2);
                    int n = 1;
                    return n;
                }
                this.zzp(intent);
            }
        }
        finally {
            this.stop();
        }
        if (intent.getStringExtra("from") != null) {
            GcmReceiver.completeWakefulIntent((Intent)intent);
        }
        return 2;
    }

    public void zzal(boolean bl) {
        this.onTokenRefresh();
    }

    public void onTokenRefresh() {
    }
}

