/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;

public class PeriodicTask
extends Task {
    protected long mIntervalInSeconds = -1L;
    protected long mFlexInSeconds = -1L;
    public static final Parcelable.Creator<PeriodicTask> CREATOR = new Parcelable.Creator<PeriodicTask>(){

        public PeriodicTask zzeO(Parcel parcel) {
            return new PeriodicTask(parcel);
        }

        public PeriodicTask[] zzhJ(int n) {
            return new PeriodicTask[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.zzhJ(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzeO(parcel);
        }
    };

    private PeriodicTask(Builder builder) {
        super(builder);
        this.mIntervalInSeconds = builder.zzaTk;
        this.mFlexInSeconds = Math.min(builder.zzaTl, this.mIntervalInSeconds);
    }

    @Deprecated
    private PeriodicTask(Parcel parcel) {
        super(parcel);
        this.mIntervalInSeconds = parcel.readLong();
        this.mFlexInSeconds = Math.min(parcel.readLong(), this.mIntervalInSeconds);
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("period", this.mIntervalInSeconds);
        bundle.putLong("period_flex", this.mFlexInSeconds);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeLong(this.mIntervalInSeconds);
        parcel.writeLong(this.mFlexInSeconds);
    }

    public long getPeriod() {
        return this.mIntervalInSeconds;
    }

    public long getFlex() {
        return this.mFlexInSeconds;
    }

    public String toString() {
        String string = String.valueOf(super.toString());
        long l = this.getPeriod();
        long l2 = this.getFlex();
        return new StringBuilder(54 + String.valueOf(string).length()).append(string).append(" period=").append(l).append(" flex=").append(l2).toString();
    }

    public static class Builder
    extends Task.Builder {
        private long zzaTk = -1L;
        private long zzaTl = -1L;

        public Builder() {
            this.isPersisted = true;
        }

        public Builder setPeriod(long l) {
            this.zzaTk = l;
            return this;
        }

        public Builder setFlex(long l) {
            this.zzaTl = l;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> clazz) {
            this.gcmTaskService = clazz.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int n) {
            this.requiredNetworkState = n;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean bl) {
            this.requiresCharging = bl;
            return this;
        }

        @Override
        public Builder setTag(String string) {
            this.tag = string;
            return this;
        }

        @Override
        public Builder setPersisted(boolean bl) {
            this.isPersisted = bl;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean bl) {
            this.updateCurrent = bl;
            return this;
        }

        @Override
        public Builder setExtras(Bundle bundle) {
            this.extras = bundle;
            return this;
        }

        @Override
        public PeriodicTask build() {
            this.checkConditions();
            return new PeriodicTask(this);
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzaTk == -1L) {
                throw new IllegalArgumentException("Must call setPeriod(long) to establish an execution interval for this periodic task.");
            }
            if (this.zzaTk <= 0L) {
                long l = this.zzaTk;
                throw new IllegalArgumentException(new StringBuilder(66).append("Period set cannot be less than or equal to 0: ").append(l).toString());
            }
            if (this.zzaTl == -1L) {
                this.zzaTl = (long)((float)this.zzaTk * 0.1f);
            } else if (this.zzaTl > this.zzaTk) {
                this.zzaTl = this.zzaTk;
            }
        }
    }
}

