/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.identitycredentials;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.identitycredentials.CallingAppInfo;
import com.google.android.gms.identitycredentials.Credential;
import com.google.android.gms.identitycredentials.GetCredentialException;
import com.google.android.gms.identitycredentials.GetCredentialRequest;
import com.google.android.gms.identitycredentials.GetCredentialResponse;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u001aH\u0007J\"\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0007J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0014\u0010$\u001a\u00020%2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010&\u001a\u00020'2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/google/android/gms/identitycredentials/IntentHelper;", "", "<init>", "()V", "ACTION_GET_CREDENTIAL", "", "ACTION_IMPORT_CREDENTIAL", "EXTRA_GET_CREDENTIAL_REQUEST", "EXTRA_IMPORT_CREDENTIALS_REQUEST", "EXTRA_IMPORT_CREDENTIALS_REQUEST_JSON", "EXTRA_CALLING_PACKAGE_NAME", "EXTRA_SIGNATURE_COUNT", "EXTRA_SIGNATURE_PREFIX", "EXTRA_ORIGIN", "EXTRA_CREDENTIAL_ID", "extractGetCredentialRequest", "Lcom/google/android/gms/identitycredentials/GetCredentialRequest;", "intent", "Landroid/content/Intent;", "extractCallingAppInfo", "Lcom/google/android/gms/identitycredentials/CallingAppInfo;", "setImportCredentialsResponse", "", "response", "Lcom/google/android/gms/identitycredentials/ImportCredentialsResponse;", "setGetCredentialResponse", "Lcom/google/android/gms/identitycredentials/GetCredentialResponse;", "setGetCredentialException", "errorType", "errorMessage", "extractImportCredentialsResponse", "resultCode", "", "resultData", "Landroid/os/Bundle;", "extractGetCredentialResponse", "newUnknownException", "Lcom/google/android/gms/identitycredentials/GetCredentialException;", "newUnknownImportCredentialsException", "Lcom/google/android/gms/identitycredentials/ImportCredentialsException;", "EXTRA_EXCEPTION_TYPE", "EXTRA_IMPORT_CREDENTIALS_RESPONSE", "EXTRA_EXCEPTION_MESSAGE", "EXTRA_CREDENTIAL_TYPE", "EXTRA_CREDENTIAL_DATA", "BUNDLE_KEY_PROVIDER_DATA", "BUNDLE_KEY_EXCEPTION_TYPE", "BUNDLE_KEY_EXCEPTION_MESSAGE", "java.com.google.android.gmscore.integ.client.identity_credentials_identity_credentials"})
public final class IntentHelper {
    @NotNull
    public static final IntentHelper INSTANCE = new IntentHelper();
    @NotNull
    public static final String ACTION_GET_CREDENTIAL = "androidx.identitycredentials.action.GET_CREDENTIALS";
    @NotNull
    public static final String EXTRA_CREDENTIAL_ID = "androidx.identitycredentials.extra.CREDENTIAL_ID";

    @JvmStatic
    @androidx.annotation.Nullable
    public static final CallingAppInfo extractCallingAppInfo(@NonNull Intent intent) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        object.setExtrasClassLoader(null);
        String string = object.getStringExtra("androidx.identitycredentials.extra.CALLING_PACKAGE_NAME");
        if (string == null) {
            return null;
        }
        String string2 = object.getStringExtra("androidx.identitycredentials.extra.ORIGIN");
        int n = object.getIntExtra("androidx.identitycredentials.extra.SIGNATURE_COUNT", 0);
        List list = new ArrayList();
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("androidx.identitycredentials.extra.SIGNATURE_");
            stringBuilder.append(i);
            byte[] byArray = object.getByteArrayExtra(stringBuilder.toString());
            if (byArray == null) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("cannot find expected signature at count ");
                stringBuilder2.append(i);
                object = stringBuilder2.toString();
                Log.w((String)"IntentHelper", (String)object);
                return null;
            }
            list.add(byArray);
        }
        return new CallingAppInfo(string, list, string2);
    }

    private final GetCredentialException newUnknownException(String string) {
        return new GetCredentialException("android.credentials.GetCredentialException.TYPE_UNKNOWN", string);
    }

    @JvmStatic
    @androidx.annotation.Nullable
    public static final GetCredentialRequest extractGetCredentialRequest(@NonNull Intent intent) {
        Intent intent2;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        intent2.setExtrasClassLoader(GetCredentialRequest.class.getClassLoader());
        return (GetCredentialRequest)intent2.getParcelableExtra("androidx.identitycredentials.extra.GET_CREDENTIAL_REQUEST");
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmStatic
    @NotNull
    public static final GetCredentialResponse extractGetCredentialResponse(int resultCode, @NonNull Bundle resultData) throws GetCredentialException {
        Intent intent;
        Object object;
        block8: {
            CharSequence charSequence;
            int n;
            Intrinsics.checkNotNullParameter((Object)resultData, (String)"resultData");
            switch (n) {
                case 0: {
                    charSequence = object.getCharSequence("androidx.identitycredentials.BUNDLE_KEY_EXCEPTION_TYPE");
                    charSequence = charSequence != null ? ((Object)charSequence).toString() : "android.credentials.GetCredentialException.TYPE_USER_CANCELED";
                }
                case -1: {
                    intent = Build.VERSION.SDK_INT >= 33 ? (Intent)object.getParcelable("androidx.identitycredentials.BUNDLE_KEY_PROVIDER_DATA", Intent.class) : (Intent)object.getParcelable("androidx.identitycredentials.BUNDLE_KEY_PROVIDER_DATA");
                    if (intent == null) {
                        throw INSTANCE.newUnknownException("Provider result is empty");
                    }
                    if (intent.hasExtra("androidx.identitycredentials.EXTRA_CREDENTIAL_TYPE")) {
                        object = intent.getStringExtra("androidx.identitycredentials.EXTRA_CREDENTIAL_TYPE");
                        intent = intent.getBundleExtra("androidx.identitycredentials.EXTRA_CREDENTIAL_DATA");
                        if (object == null) throw INSTANCE.newUnknownException("Credential result is empty");
                        if (intent == null) throw INSTANCE.newUnknownException("Credential result is empty");
                        return new GetCredentialResponse(new Credential((String)object, (Bundle)intent));
                    }
                    break block8;
                }
                default: {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Activity result has unexpected resultCode: ");
                    stringBuilder.append(n);
                    throw INSTANCE.newUnknownException(stringBuilder.toString());
                }
            }
            if ((object = object.getCharSequence("androidx.identitycredentials.BUNDLE_KEY_EXCEPTION_MESSAGE")) != null) {
                object = object.toString();
                throw new GetCredentialException((String)charSequence, (String)object);
            }
            object = null;
            throw new GetCredentialException((String)charSequence, (String)object);
        }
        if (!intent.hasExtra("androidx.identitycredentials.EXTRA_EXCEPTION_TYPE")) throw INSTANCE.newUnknownException("Unknown provider error");
        String string = intent.getStringExtra("androidx.identitycredentials.EXTRA_EXCEPTION_TYPE");
        if (string != null) {
            ((GetCredentialException)object)(string, intent.getStringExtra("androidx.identitycredentials.EXTRA_EXCEPTION_MESSAGE"));
            throw object;
        }
        throw INSTANCE.newUnknownException("Unknown provider error");
    }

    private IntentHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void setGetCredentialException(@NonNull Intent intent, @NonNull String errorType, @Nullable String errorMessage) {
        void var2_2;
        Intent intent2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"errorType");
        intent2.putExtra("androidx.identitycredentials.EXTRA_EXCEPTION_TYPE", (String)var1_1);
        intent2.putExtra("androidx.identitycredentials.EXTRA_EXCEPTION_MESSAGE", (String)var2_2);
    }

    @JvmStatic
    public static final void setGetCredentialResponse(@NonNull Intent intent, @NonNull GetCredentialResponse response) {
        Intent intent2;
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"response");
        String string = bundle.getCredential().getType();
        intent2.putExtra("androidx.identitycredentials.EXTRA_CREDENTIAL_TYPE", string);
        bundle = bundle.getCredential().getData();
        intent2.putExtra("androidx.identitycredentials.EXTRA_CREDENTIAL_DATA", bundle);
    }
}

