/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Looper;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.iid.zzc;
import com.google.android.gms.iid.zzd;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class InstanceID {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_TIMEOUT = "TIMEOUT";
    public static final String ERROR_MISSING_INSTANCEID_SERVICE = "MISSING_INSTANCEID_SERVICE";
    public static final String ERROR_BACKOFF = "RETRY_LATER";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    static Map<String, InstanceID> zzbha = new HashMap<String, InstanceID>();
    Context mContext;
    private static zzd zzbhb;
    private static zzc zzbhc;
    KeyPair zzbhd;
    String zzbhe = "";
    long zzbhf;
    static String zzbhg;

    protected InstanceID(Context context, String string, Bundle bundle) {
        this.mContext = context.getApplicationContext();
        this.zzbhe = string;
    }

    static int zzbf(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return 0;
        }
    }

    static String zzbg(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    public static InstanceID getInstance(Context context) {
        return InstanceID.zza(context, null);
    }

    public static synchronized InstanceID zza(Context context, Bundle bundle) {
        String string;
        String string2 = string = bundle == null ? "" : bundle.getString("subtype");
        if (string == null) {
            string = "";
        }
        context = context.getApplicationContext();
        if (zzbhb == null) {
            zzbhb = new zzd(context);
            zzbhc = new zzc(context);
        }
        zzbhg = Integer.toString(InstanceID.zzbf(context));
        InstanceID instanceID = zzbha.get(string);
        if (instanceID == null) {
            instanceID = new InstanceID(context, string, bundle);
            zzbha.put(string, instanceID);
        }
        return instanceID;
    }

    static String zzv(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    KeyPair zzGt() {
        if (this.zzbhd == null) {
            this.zzbhd = zzbhb.zzeM(this.zzbhe);
        }
        if (this.zzbhd == null) {
            this.zzbhf = System.currentTimeMillis();
            this.zzbhd = zzbhb.zze(this.zzbhe, this.zzbhf);
        }
        return this.zzbhd;
    }

    public String getId() {
        return InstanceID.zza(this.zzGt());
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray2 = messageDigest.digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)(n & 0xFF);
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"InstanceID", (String)"Unexpected error, device missing required alghorithms");
            return null;
        }
    }

    public long getCreationTime() {
        String string;
        if (this.zzbhf == 0L && (string = zzbhb.get(this.zzbhe, "cre")) != null) {
            this.zzbhf = Long.parseLong(string);
        }
        return this.zzbhf;
    }

    public void deleteInstanceID() throws IOException {
        this.zzb("*", "*", null);
        this.zzGu();
    }

    public void zzGu() {
        this.zzbhf = 0L;
        zzbhb.zzeN(this.zzbhe);
        this.zzbhd = null;
    }

    public void deleteToken(String string, String string2) throws IOException {
        this.zzb(string, string2, null);
    }

    public void zzb(String string, String string2, Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        zzbhb.zzi(this.zzbhe, string, string2);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("sender", string);
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("subscription", string);
        bundle.putString("delete", "1");
        bundle.putString("X-delete", "1");
        bundle.putString("subtype", "".equals(this.zzbhe) ? string : this.zzbhe);
        bundle.putString("X-subtype", "".equals(this.zzbhe) ? string : this.zzbhe);
        Intent intent = zzbhc.zza(bundle, this.zzGt());
        zzbhc.zzt(intent);
    }

    public zzd zzGv() {
        return zzbhb;
    }

    public zzc zzGw() {
        return zzbhc;
    }

    public String getToken(String string, String string2) throws IOException {
        return this.getToken(string, string2, null);
    }

    public String getToken(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        boolean bl = true;
        String string4 = string3 = this.zzGx() ? null : zzbhb.zzh(this.zzbhe, string, string2);
        if (string3 != null) {
            return string3;
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (bundle.getString("ttl") != null) {
            bl = false;
        }
        if ("jwt".equals(bundle.getString("type"))) {
            bl = false;
        }
        if ((string3 = this.zzc(string, string2, bundle)) != null && bl) {
            zzbhb.zza(this.zzbhe, string, string2, string3, zzbhg);
        }
        return string3;
    }

    public String zzc(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("sender", string);
        String string4 = string3 = "".equals(this.zzbhe) ? string : this.zzbhe;
        if (!bundle.containsKey("legacy.register")) {
            bundle.putString("subscription", string);
            bundle.putString("subtype", string3);
            bundle.putString("X-subscription", string);
            bundle.putString("X-subtype", string3);
        }
        Intent intent = zzbhc.zza(bundle, this.zzGt());
        return zzbhc.zzt(intent);
    }

    boolean zzGx() {
        String string = zzbhb.get("appVersion");
        if (string == null || !string.equals(zzbhg)) {
            return true;
        }
        String string2 = zzbhb.get("lastToken");
        if (string2 == null) {
            return true;
        }
        Long l = Long.parseLong(string2);
        return System.currentTimeMillis() / 1000L - l > 604800L;
    }
}

