/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.zzx;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.zza;
import java.io.File;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;

public class zzd {
    SharedPreferences zzbif;
    Context zzqn;

    public zzd(Context context) {
        this(context, "com.google.android.gms.appid");
    }

    public zzd(Context context, String string) {
        this.zzqn = context;
        this.zzbif = context.getSharedPreferences(string, 0);
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("-no-backup");
        this.zzeG(string3.length() != 0 ? string2.concat(string3) : new String(string2));
    }

    private void zzeG(String string) {
        block4: {
            File file = zzx.getNoBackupFilesDir((Context)this.zzqn);
            File file2 = new File(file, string);
            if (file2.exists()) {
                return;
            }
            try {
                if (file2.createNewFile() && !this.isEmpty()) {
                    Log.i((String)"InstanceID/Store", (String)"App restored, clearing state");
                    InstanceIDListenerService.zza(this.zzqn, this);
                }
            }
            catch (IOException iOException) {
                if (!Log.isLoggable((String)"InstanceID/Store", (int)3)) break block4;
                String string2 = String.valueOf(iOException.getMessage());
                Log.d((String)"InstanceID/Store", (String)(string2.length() != 0 ? "Error creating file in no backup dir: ".concat(string2) : new String("Error creating file in no backup dir: ")));
            }
        }
    }

    public boolean isEmpty() {
        return this.zzbif.getAll().isEmpty();
    }

    private String zzg(String string, String string2, String string3) {
        String string4 = String.valueOf("|T|");
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string4).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string4).append(string2).append("|").append(string3).toString();
    }

    synchronized String get(String string, String string2) {
        String string3 = String.valueOf("|S|");
        return this.zzbif.getString(new StringBuilder(String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string).append(string3).append(string2).toString(), null);
    }

    synchronized String get(String string) {
        return this.zzbif.getString(string, null);
    }

    synchronized void zza(SharedPreferences.Editor editor, String string, String string2, String string3) {
        String string4 = String.valueOf("|S|");
        editor.putString(new StringBuilder(String.valueOf(string).length() + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string).append(string4).append(string2).toString(), string3);
    }

    public synchronized void zzeH(String string) {
        SharedPreferences.Editor editor = this.zzbif.edit();
        Map map = this.zzbif.getAll();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            editor.remove(string2);
        }
        editor.commit();
    }

    public synchronized void zzHo() {
        this.zzbif.edit().clear().commit();
    }

    public synchronized String zzh(String string, String string2, String string3) {
        String string4 = this.zzg(string, string2, string3);
        String string5 = this.zzbif.getString(string4, null);
        return string5;
    }

    public synchronized void zza(String string, String string2, String string3, String string4, String string5) {
        String string6 = this.zzg(string, string2, string3);
        SharedPreferences.Editor editor = this.zzbif.edit();
        editor.putString(string6, string4);
        editor.putString("appVersion", string5);
        editor.putString("lastToken", Long.toString(System.currentTimeMillis() / 1000L));
        editor.commit();
    }

    public synchronized void zzi(String string, String string2, String string3) {
        String string4 = this.zzg(string, string2, string3);
        SharedPreferences.Editor editor = this.zzbif.edit();
        editor.remove(string4);
        editor.commit();
    }

    public KeyPair zzeI(String string) {
        return this.zzeL(string);
    }

    synchronized KeyPair zze(String string, long l) {
        KeyPair keyPair = zza.zzHg();
        SharedPreferences.Editor editor = this.zzbif.edit();
        this.zza(editor, string, "|P|", InstanceID.zzv(keyPair.getPublic().getEncoded()));
        this.zza(editor, string, "|K|", InstanceID.zzv(keyPair.getPrivate().getEncoded()));
        this.zza(editor, string, "cre", Long.toString(l));
        editor.commit();
        return keyPair;
    }

    void zzeJ(String string) {
        this.zzeH(String.valueOf(string).concat("|"));
    }

    public void zzeK(String string) {
        this.zzeH(String.valueOf(string).concat("|T|"));
    }

    KeyPair zzeL(String string) {
        String string2 = this.get(string, "|P|");
        String string3 = this.get(string, "|K|");
        if (string2 == null || string3 == null) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)string2, (int)8);
            byte[] byArray2 = Base64.decode((String)string3, (int)8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string4 = String.valueOf(generalSecurityException);
            Log.w((String)"InstanceID/Store", (String)new StringBuilder(19 + String.valueOf(string4).length()).append("Invalid key stored ").append(string4).toString());
            InstanceIDListenerService.zza(this.zzqn, this);
            return null;
        }
    }
}

