/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.MessengerCompat;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class zzc {
    static String zzbhQ = null;
    static boolean zzbhR = false;
    static int zzbhS = 0;
    static int zzbhT = 0;
    static int zzbhU = 0;
    static BroadcastReceiver zzbhV = null;
    Context zzqn;
    Map<String, Object> zzbhW = new HashMap<String, Object>();
    Messenger zzbgK;
    Messenger zzbhX;
    MessengerCompat zzbhY;
    PendingIntent zzbgG;
    long zzbhZ;
    long zzbia;
    int zzbib;
    int zzbic;
    long zzbid;

    public zzc(Context context) {
        this.zzqn = context;
    }

    public static boolean zzbz(Context context) {
        if (zzbhQ != null) {
            zzc.zzbA(context);
        }
        return zzbhR;
    }

    public static String zzbA(Context context) {
        if (zzbhQ != null) {
            return zzbhQ;
        }
        zzbhS = Process.myUid();
        PackageManager packageManager = context.getPackageManager();
        if (zzt.zzzq() ? zzc.zzb(packageManager) || zzc.zza(packageManager) : zzc.zza(packageManager) || zzc.zzb(packageManager)) {
            return zzbhQ;
        }
        Log.w((String)"InstanceID/Rpc", (String)"Failed to resolve IID implementation package, falling back");
        if (zzc.zzb(packageManager, "com.google.android.gms")) {
            zzbhR = zzt.zzzq();
            return zzbhQ;
        }
        if (Build.VERSION.SDK_INT < 21 && zzc.zzb(packageManager, "com.google.android.gsf")) {
            zzbhR = false;
            return zzbhQ;
        }
        Log.w((String)"InstanceID/Rpc", (String)"Google Play services is missing, unable to get tokens");
        return null;
    }

    private static boolean zza(PackageManager packageManager) {
        List list = packageManager.queryIntentServices(new Intent("com.google.android.c2dm.intent.REGISTER"), 0);
        for (ResolveInfo resolveInfo : list) {
            String string = resolveInfo.serviceInfo.packageName;
            if (!zzc.zza(packageManager, string, "com.google.android.c2dm.intent.REGISTER")) continue;
            zzbhR = false;
            return true;
        }
        return false;
    }

    private static boolean zzb(PackageManager packageManager) {
        List list = packageManager.queryBroadcastReceivers(new Intent("com.google.iid.TOKEN_REQUEST"), 0);
        for (ResolveInfo resolveInfo : list) {
            String string = resolveInfo.activityInfo.packageName;
            if (!zzc.zza(packageManager, string, "com.google.iid.TOKEN_REQUEST")) continue;
            zzbhR = true;
            return true;
        }
        return false;
    }

    private static boolean zza(PackageManager packageManager, String string, String string2) {
        if (0 == packageManager.checkPermission("com.google.android.c2dm.permission.SEND", string)) {
            return zzc.zzb(packageManager, string);
        }
        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Possible malicious package ").append(string).append(" declares ").append(string2).append(" without permission").toString());
        return false;
    }

    private static boolean zzb(PackageManager packageManager, String string) {
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string, 0);
            zzbhQ = applicationInfo.packageName;
            zzbhT = applicationInfo.uid;
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private static int zzbB(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(zzc.zzbA(context), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return -1;
        }
    }

    static String zza(KeyPair keyPair, String ... stringArray) {
        byte[] byArray;
        try {
            byArray = TextUtils.join((CharSequence)"\n", (Object[])stringArray).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to encode string", (Throwable)unsupportedEncodingException);
            return null;
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            String string = privateKey instanceof RSAPrivateKey ? "SHA256withRSA" : "SHA256withECDSA";
            Signature signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            return InstanceID.zzv(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to sign registration request", (Throwable)generalSecurityException);
            return null;
        }
    }

    void zzHl() {
        if (this.zzbgK != null) {
            return;
        }
        zzc.zzbA(this.zzqn);
        this.zzbgK = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                zzc.this.zze(message);
            }
        });
    }

    public void zze(Message message) {
        if (message == null) {
            return;
        }
        if (message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.zzbhY = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzbhX = (Messenger)parcelable;
                }
            }
            this.zzs((Intent)message.obj);
        } else {
            Log.w((String)"InstanceID/Rpc", (String)"Dropping invalid message");
        }
    }

    synchronized void zzp(Intent intent) {
        if (this.zzbgG == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzbgG = PendingIntent.getBroadcast((Context)this.zzqn, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzbgG);
    }

    void zza(Bundle bundle, KeyPair keyPair, String string) throws IOException {
        long l = SystemClock.elapsedRealtime();
        if (this.zzbid != 0L && l <= this.zzbid) {
            long l2 = this.zzbid - l;
            int n = this.zzbic;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(78).append("Backoff mode, next request attempt: ").append(l2).append(" interval: ").append(n).toString());
            throw new IOException("RETRY_LATER");
        }
        this.zzHl();
        if (zzbhQ == null) {
            throw new IOException("MISSING_INSTANCEID_SERVICE");
        }
        this.zzbhZ = SystemClock.elapsedRealtime();
        Intent intent = new Intent(zzbhR ? "com.google.iid.TOKEN_REQUEST" : "com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(zzbhQ);
        int n = zzc.zzbB(this.zzqn);
        bundle.putString("gmsv", Integer.toString(n));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", Integer.toString(InstanceID.zzbw(this.zzqn)));
        bundle.putString("app_ver_name", InstanceID.zzbx(this.zzqn));
        bundle.putString("cliv", "iid-10260000");
        bundle.putString("appid", InstanceID.zza(keyPair));
        String string2 = InstanceID.zzv(keyPair.getPublic().getEncoded());
        bundle.putString("pub2", string2);
        bundle.putString("sig", zzc.zza(keyPair, this.zzqn.getPackageName(), string2));
        intent.putExtras(bundle);
        this.zzp(intent);
        this.zzb(intent, string);
    }

    protected void zzb(Intent intent, String string) {
        block12: {
            String string2;
            boolean bl;
            block11: {
                this.zzbhZ = SystemClock.elapsedRealtime();
                intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
                intent.putExtra("X-kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
                bl = "com.google.android.gsf".equals(zzbhQ);
                String string3 = intent.getStringExtra("useGsf");
                if (string3 != null) {
                    bl = "1".equals(string3);
                }
                if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                    string2 = String.valueOf(intent.getExtras());
                    Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
                }
                if (this.zzbhX != null) {
                    intent.putExtra("google.messenger", (Parcelable)this.zzbgK);
                    string2 = Message.obtain();
                    ((Message)string2).obj = intent;
                    try {
                        this.zzbhX.send((Message)string2);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block11;
                        Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            if (bl) {
                this.zzHm();
                this.zzqn.sendBroadcast(intent);
                return;
            }
            intent.putExtra("google.messenger", (Parcelable)this.zzbgK);
            intent.putExtra("messenger2", "1");
            if (this.zzbhY != null) {
                string2 = Message.obtain();
                ((Message)string2).obj = intent;
                try {
                    this.zzbhY.send((Message)string2);
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block12;
                    Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                }
            }
        }
        if (zzbhR) {
            this.zzqn.sendBroadcast(intent);
        } else {
            this.zzqn.startService(intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzHm() {
        zzc zzc2 = this;
        synchronized (zzc2) {
            if (zzbhV == null) {
                zzbhV = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                            Log.d((String)"InstanceID/Rpc", (String)"Received GSF callback via dynamic receiver");
                        }
                        zzc.this.zzs(intent);
                    }
                };
                if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                    Log.d((String)"InstanceID/Rpc", (String)"Registered GSF callback receiver");
                }
                IntentFilter intentFilter = new IntentFilter("com.google.android.c2dm.intent.REGISTRATION");
                intentFilter.addCategory(this.zzqn.getPackageName());
                this.zzqn.registerReceiver(zzbhV, intentFilter, "com.google.android.c2dm.permission.SEND", null);
            }
        }
    }

    String zzq(Intent intent) throws IOException {
        if (intent == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string = intent.getStringExtra("registration_id");
        if (string == null) {
            string = intent.getStringExtra("unregistered");
        }
        intent.getLongExtra("Retry-After", 0L);
        if (string == null) {
            string = intent.getStringExtra("error");
            if (string != null) {
                throw new IOException(string);
            }
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Unexpected response from GCM ").append(string2).toString(), (Throwable)new Throwable());
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        return string;
    }

    void zzr(Intent intent) {
        String string = intent.getStringExtra("error");
        if (string == null) {
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("Unexpected response, no error or registration id ").append(string2).toString());
            return;
        }
        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
            String string3 = String.valueOf(string);
            Log.d((String)"InstanceID/Rpc", (String)(string3.length() != 0 ? "Received InstanceID error ".concat(string3) : new String("Received InstanceID error ")));
        }
        String string4 = null;
        if (string.startsWith("|")) {
            String[] stringArray = string.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            if (stringArray.length > 2) {
                string4 = stringArray[2];
                string = stringArray[3];
                if (string.startsWith(":")) {
                    string = string.substring(1);
                }
            } else {
                string = "UNKNOWN";
            }
            intent.putExtra("error", string);
        }
        if (null == string4) {
            this.zzG(string);
        } else {
            this.zzi(string4, string);
        }
        long l = intent.getLongExtra("Retry-After", 0L);
        if (l > 0L) {
            this.zzbia = SystemClock.elapsedRealtime();
            this.zzbic = (int)l * 1000;
            this.zzbid = SystemClock.elapsedRealtime() + (long)this.zzbic;
            int n = this.zzbic;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(52).append("Explicit request from server to backoff: ").append(n).toString());
        } else if ("SERVICE_NOT_AVAILABLE".equals(string) || "AUTHENTICATION_FAILED".equals(string)) {
            this.zzeF(string);
        }
    }

    private void zzeF(String string) {
        if (!"com.google.android.gsf".equals(zzbhQ)) {
            return;
        }
        ++this.zzbib;
        if (this.zzbib < 3) {
            return;
        }
        if (this.zzbib == 3) {
            this.zzbic = 1000 + new Random().nextInt(1000);
        }
        this.zzbic *= 2;
        this.zzbid = SystemClock.elapsedRealtime() + (long)this.zzbic;
        int n = this.zzbic;
        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(31 + String.valueOf(string).length()).append("Backoff due to ").append(string).append(" for ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzG(Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            for (String string : this.zzbhW.keySet()) {
                Object object2 = this.zzbhW.get(string);
                this.zzbhW.put(string, object);
                this.zzg(object2, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzi(String string, Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Object object2 = this.zzbhW.get(string);
            this.zzbhW.put(string, object);
            this.zzg(object2, object);
        }
    }

    private void zzg(Object object, Object object2) {
        if (object instanceof ConditionVariable) {
            ((ConditionVariable)object).open();
        }
        if (object instanceof Messenger) {
            Messenger messenger = (Messenger)object;
            Message message = Message.obtain();
            message.obj = object2;
            try {
                messenger.send(message);
            }
            catch (RemoteException remoteException) {
                String string = String.valueOf((Object)remoteException);
                Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(24 + String.valueOf(string).length()).append("Failed to send response ").append(string).toString());
            }
        }
    }

    public void zzs(Intent intent) {
        if (intent == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Unexpected response: null");
            }
            return;
        }
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string) && !"com.google.android.gms.iid.InstanceID".equals(string)) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string2 = String.valueOf(intent.getAction());
                Log.d((String)"InstanceID/Rpc", (String)(string2.length() != 0 ? "Unexpected response ".concat(string2) : new String("Unexpected response ")));
            }
            return;
        }
        String string3 = intent.getStringExtra("registration_id");
        if (string3 == null) {
            string3 = intent.getStringExtra("unregistered");
        }
        if (string3 == null) {
            this.zzr(intent);
            return;
        }
        this.zzbhZ = SystemClock.elapsedRealtime();
        this.zzbid = 0L;
        this.zzbib = 0;
        this.zzbic = 0;
        String string4 = null;
        if (string3.startsWith("|")) {
            String[] stringArray = string3.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string3);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            string4 = stringArray[2];
            if (stringArray.length > 4) {
                if ("SYNC".equals(stringArray[3])) {
                    InstanceIDListenerService.zzby(this.zzqn);
                } else if ("RST".equals(stringArray[3])) {
                    InstanceIDListenerService.zza(this.zzqn, InstanceID.getInstance(this.zzqn).zzHj());
                    intent.removeExtra("registration_id");
                    this.zzi(string4, intent);
                    return;
                }
            }
            if ((string3 = stringArray[stringArray.length - 1]).startsWith(":")) {
                string3 = string3.substring(1);
            }
            intent.putExtra("registration_id", string3);
        }
        if (null == string4) {
            this.zzG(intent);
        } else {
            this.zzi(string4, intent);
        }
    }

    Intent zza(Bundle bundle, KeyPair keyPair) throws IOException {
        Intent intent = this.zzb(bundle, keyPair);
        if (intent != null && intent.hasExtra("google.messenger") && (intent = this.zzb(bundle, keyPair)) != null && intent.hasExtra("google.messenger")) {
            intent = null;
        }
        return intent;
    }

    public static synchronized String zzHn() {
        return Integer.toString(zzbhU++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Intent zzb(Bundle bundle, KeyPair keyPair) throws IOException {
        ConditionVariable conditionVariable = new ConditionVariable();
        String string = zzc.zzHn();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.zzbhW.put(string, conditionVariable);
        }
        this.zza(bundle, keyPair, string);
        conditionVariable.block(30000L);
        clazz = this.getClass();
        synchronized (clazz) {
            Object object = this.zzbhW.remove(string);
            if (object instanceof Intent) {
                return (Intent)object;
            }
            if (object instanceof String) {
                throw new IOException((String)object);
            }
            String string2 = String.valueOf(object);
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(12 + String.valueOf(string2).length()).append("No response ").append(string2).toString());
            throw new IOException("TIMEOUT");
        }
    }
}

