/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Looper;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.iid.zze;
import com.google.android.gms.iid.zzh;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class InstanceID {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_TIMEOUT = "TIMEOUT";
    public static final String ERROR_MISSING_INSTANCEID_SERVICE = "MISSING_INSTANCEID_SERVICE";
    public static final String ERROR_BACKOFF = "RETRY_LATER";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    private static Map<String, InstanceID> zzbgQ = new HashMap<String, InstanceID>();
    private Context mContext;
    private static zzh zzbgR;
    private static zze zzbgS;
    private KeyPair zzbgT;
    private String zzbgU = "";
    private long zzbgV;
    private static String zzbgW;

    private InstanceID(Context context, String string, Bundle bundle) {
        this.mContext = context.getApplicationContext();
        this.zzbgU = string;
    }

    static int zzba(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return 0;
        }
    }

    static String zzbb(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    public static InstanceID getInstance(Context context) {
        return InstanceID.zza(context, null);
    }

    public static synchronized InstanceID zza(Context context, Bundle bundle) {
        String string = bundle == null ? "" : bundle.getString("subtype");
        if (string == null) {
            string = "";
        }
        context = context.getApplicationContext();
        if (zzbgR == null) {
            zzbgR = new zzh(context);
            zzbgS = new zze(context);
        }
        zzbgW = Integer.toString(InstanceID.zzba(context));
        InstanceID instanceID = zzbgQ.get(string);
        if (instanceID == null) {
            instanceID = new InstanceID(context, string, bundle);
            zzbgQ.put(string, instanceID);
        }
        return instanceID;
    }

    static String zzj(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    private final KeyPair zzvK() {
        if (this.zzbgT == null) {
            String string = this.zzbgU;
            this.zzbgT = zzbgR.zzds(string);
        }
        if (this.zzbgT == null) {
            this.zzbgV = System.currentTimeMillis();
            this.zzbgT = zzbgR.zzc(this.zzbgU, this.zzbgV);
        }
        return this.zzbgT;
    }

    public String getId() {
        return InstanceID.zza(this.zzvK());
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"InstanceID", (String)"Unexpected error, device missing required alghorithms");
            return null;
        }
    }

    public long getCreationTime() {
        String string;
        if (this.zzbgV == 0L && (string = zzbgR.get(this.zzbgU, "cre")) != null) {
            this.zzbgV = Long.parseLong(string);
        }
        return this.zzbgV;
    }

    public void deleteInstanceID() throws IOException {
        this.zzb("*", "*", null);
        this.zzvL();
    }

    public final void zzvL() {
        this.zzbgV = 0L;
        String string = this.zzbgU;
        zzbgR.zzdq(String.valueOf(string).concat("|"));
        this.zzbgT = null;
    }

    public void deleteToken(String string, String string2) throws IOException {
        this.zzb(string, string2, null);
    }

    public final void zzb(String string, String string2, Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        zzbgR.zzg(this.zzbgU, string, string2);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("sender", string);
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("subscription", string);
        bundle.putString("delete", "1");
        bundle.putString("X-delete", "1");
        bundle.putString("subtype", "".equals(this.zzbgU) ? string : this.zzbgU);
        bundle.putString("X-subtype", "".equals(this.zzbgU) ? string : this.zzbgU);
        zze.zzh(zzbgS.zza(bundle, this.zzvK()));
    }

    public static zzh zzvM() {
        return zzbgR;
    }

    public String getToken(String string, String string2) throws IOException {
        return this.getToken(string, string2, null);
    }

    public String getToken(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        boolean bl;
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        boolean bl2 = true;
        String string4 = zzbgR.get("appVersion");
        if (string4 == null || !string4.equals(zzbgW)) {
            bl = true;
        } else {
            String string5 = zzbgR.get("lastToken");
            if (string5 == null) {
                bl = true;
            } else {
                Long l = Long.parseLong(string5);
                bl = System.currentTimeMillis() / 1000L - l > 604800L;
            }
        }
        if ((string3 = bl ? null : zzbgR.zzf(this.zzbgU, string, string2)) != null) {
            return string3;
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (bundle.getString("ttl") != null) {
            bl2 = false;
        }
        if ("jwt".equals(bundle.getString("type"))) {
            bl2 = false;
        }
        if ((string3 = this.zzc(string, string2, bundle)) != null && bl2) {
            zzbgR.zza(this.zzbgU, string, string2, string3, zzbgW);
        }
        return string3;
    }

    public final String zzc(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("sender", string);
        String string4 = string3 = "".equals(this.zzbgU) ? string : this.zzbgU;
        if (!bundle.containsKey("legacy.register")) {
            bundle.putString("subscription", string);
            bundle.putString("subtype", string3);
            bundle.putString("X-subscription", string);
            bundle.putString("X-subtype", string3);
        }
        return zze.zzh(zzbgS.zza(bundle, this.zzvK()));
    }
}

