/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.zzaa;
import com.google.android.gms.iid.zzaf;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class InstanceID {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_TIMEOUT = "TIMEOUT";
    public static final String ERROR_MISSING_INSTANCEID_SERVICE = "MISSING_INSTANCEID_SERVICE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    private static Map<String, InstanceID> zza = new ArrayMap();
    private Context zzb;
    private static zzaf zzc;
    private static zzaa zzd;
    private KeyPair zze;
    private String zzf = "";
    private long zzg;
    private static String zzh;

    @Hide
    private InstanceID(Context context, String string) {
        this.zzb = context.getApplicationContext();
        this.zzf = string;
    }

    static int zza(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return 0;
        }
    }

    static String zzb(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    public static InstanceID getInstance(Context context) {
        return InstanceID.getInstance(context, null);
    }

    @Hide
    @KeepForSdk
    public static synchronized InstanceID getInstance(Context context, Bundle bundle) {
        String string = bundle == null ? "" : bundle.getString("subtype");
        if (string == null) {
            string = "";
        }
        context = context.getApplicationContext();
        if (zzc == null) {
            zzc = new zzaf(context);
            zzd = new zzaa(context);
        }
        zzh = Integer.toString(InstanceID.zza(context));
        InstanceID instanceID = zza.get(string);
        if (instanceID == null) {
            instanceID = new InstanceID(context, string);
            zza.put(string, instanceID);
        }
        return instanceID;
    }

    static String zza(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    private final KeyPair zzc() {
        if (this.zze == null) {
            String string = this.zzf;
            this.zze = zzc.zzc(string);
        }
        if (this.zze == null) {
            this.zzg = System.currentTimeMillis();
            this.zze = zzc.zza(this.zzf, this.zzg);
        }
        return this.zze;
    }

    @Hide
    @KeepForSdk
    public String getSubtype() {
        return this.zzf;
    }

    public String getId() {
        return InstanceID.zza(this.zzc());
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"InstanceID", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
    }

    public long getCreationTime() {
        String string;
        if (this.zzg == 0L && (string = zzc.zza(this.zzf, "cre")) != null) {
            this.zzg = Long.parseLong(string);
        }
        return this.zzg;
    }

    public void deleteInstanceID() throws IOException {
        this.zza("*", "*", null);
        this.zza();
    }

    @Hide
    public final void zza() {
        this.zzg = 0L;
        String string = this.zzf;
        zzc.zzb(String.valueOf(string).concat("|"));
        this.zze = null;
    }

    public void deleteToken(String string, String string2) throws IOException {
        this.zza(string, string2, null);
    }

    @Hide
    public final void zza(String string, String string2, Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        zzc.zzb(this.zzf, string, string2);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("sender", string);
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("subscription", string);
        bundle.putString("delete", "1");
        bundle.putString("X-delete", "1");
        bundle.putString("subtype", "".equals(this.zzf) ? string : this.zzf);
        bundle.putString("X-subtype", "".equals(this.zzf) ? string : this.zzf);
        zzaa.zza(zzd.zza(bundle, this.zzc()));
    }

    @Hide
    public static zzaf zzb() {
        return zzc;
    }

    public String getToken(String string, String string2) throws IOException {
        return this.getToken(string, string2, null);
    }

    public String getToken(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        boolean bl;
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        boolean bl2 = true;
        String string4 = zzc.zza("appVersion");
        if (string4 == null || !string4.equals(zzh)) {
            bl = true;
        } else {
            String string5 = zzc.zza("lastToken");
            if (string5 == null) {
                bl = true;
            } else {
                Long l = Long.parseLong(string5);
                bl = System.currentTimeMillis() / 1000L - l > 604800L;
            }
        }
        if ((string3 = bl ? null : zzc.zza(this.zzf, string, string2)) != null) {
            return string3;
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (bundle.getString("ttl") != null) {
            bl2 = false;
        }
        if ("jwt".equals(bundle.getString("type"))) {
            bl2 = false;
        }
        if ((string3 = this.zzb(string, string2, bundle)) != null && bl2) {
            zzc.zza(this.zzf, string, string2, string3, zzh);
        }
        return string3;
    }

    @Hide
    public final String zzb(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        String string4;
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("sender", string);
        String string5 = string4 = "".equals(this.zzf) ? string : this.zzf;
        if (!bundle.containsKey("legacy.register")) {
            bundle.putString("subscription", string);
            bundle.putString("subtype", string4);
            bundle.putString("X-subscription", string);
            bundle.putString("X-subtype", string4);
        }
        if ("RST".equals(string3 = zzaa.zza(zzd.zza(bundle, this.zzc()))) || string3.startsWith("RST|")) {
            InstanceIDListenerService.zza(this.zzb, zzc);
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        return string3;
    }
}

