/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.MessengerCompat;
import com.google.android.gms.iid.zzab;
import com.google.android.gms.iid.zzac;
import com.google.android.gms.iid.zzad;
import com.google.android.gms.iid.zzae;
import com.google.android.gms.iid.zzm;
import com.google.android.gms.iid.zzv;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Hide
public final class zzaa {
    private static zzae<Boolean> zzinr = zzad.zzawy().zzf("gcm_iid_use_messenger_ipc", true);
    private static String zzins = null;
    private static boolean zzint = false;
    private static int zzinu = 0;
    private static int zzinv = 0;
    private static int zzino = 0;
    private static BroadcastReceiver zzinw = null;
    private Context zzaiq;
    private Map<String, Object> zzinx = new ArrayMap();
    private Messenger zzikf;
    private Messenger zziny;
    private MessengerCompat zzinz;
    private PendingIntent zzikb;

    public zzaa(Context context) {
        this.zzaiq = context;
    }

    public static boolean zzdq(Context context) {
        if (zzins != null) {
            zzaa.zzdr(context);
        }
        return zzint;
    }

    @Hide
    public static String zzdr(Context context) {
        if (zzins != null) {
            return zzins;
        }
        zzinu = Process.myUid();
        PackageManager packageManager = context.getPackageManager();
        if (!zzs.isAtLeastO()) {
            boolean bl;
            block7: {
                PackageManager packageManager2 = packageManager;
                Iterator iterator = packageManager2.queryIntentServices(new Intent("com.google.android.c2dm.intent.REGISTER"), 0).iterator();
                while (iterator.hasNext()) {
                    String string = ((ResolveInfo)iterator.next()).serviceInfo.packageName;
                    if (!zzaa.zza(packageManager2, string, "com.google.android.c2dm.intent.REGISTER")) continue;
                    zzint = false;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            if (bl) {
                return zzins;
            }
        }
        if (zzaa.zza(packageManager)) {
            return zzins;
        }
        Log.w((String)"InstanceID/Rpc", (String)"Failed to resolve IID implementation package, falling back");
        if (zzaa.zzb(packageManager, "com.google.android.gms")) {
            zzint = zzs.isAtLeastO();
            return zzins;
        }
        if (!zzs.zzanx() && zzaa.zzb(packageManager, "com.google.android.gsf")) {
            zzint = false;
            return zzins;
        }
        Log.w((String)"InstanceID/Rpc", (String)"Google Play services is missing, unable to get tokens");
        return null;
    }

    private static boolean zza(PackageManager packageManager) {
        Iterator iterator = packageManager.queryBroadcastReceivers(new Intent("com.google.iid.TOKEN_REQUEST"), 0).iterator();
        while (iterator.hasNext()) {
            String string = ((ResolveInfo)iterator.next()).activityInfo.packageName;
            if (!zzaa.zza(packageManager, string, "com.google.iid.TOKEN_REQUEST")) continue;
            zzint = true;
            return true;
        }
        return false;
    }

    private static boolean zza(PackageManager packageManager, String string, String string2) {
        if (0 == packageManager.checkPermission("com.google.android.c2dm.permission.SEND", string)) {
            return zzaa.zzb(packageManager, string);
        }
        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Possible malicious package ").append(string).append(" declares ").append(string2).append(" without permission").toString());
        return false;
    }

    private static boolean zzb(PackageManager packageManager, String string) {
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string, 0);
            zzins = applicationInfo.packageName;
            zzinv = applicationInfo.uid;
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private static int zzds(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            return packageManager.getPackageInfo((String)zzaa.zzdr((Context)context), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return -1;
        }
    }

    private static String zza(KeyPair keyPair, String ... stringArray) {
        byte[] byArray;
        try {
            byArray = TextUtils.join((CharSequence)"\n", (Object[])stringArray).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to encode string", (Throwable)unsupportedEncodingException);
            return null;
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            Signature signature = Signature.getInstance(privateKey instanceof RSAPrivateKey ? "SHA256withRSA" : "SHA256withECDSA");
            signature.initSign(privateKey);
            signature.update(byArray);
            return InstanceID.zzp(signature.sign());
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to sign registration request", (Throwable)generalSecurityException);
            return null;
        }
    }

    public final void zzd(Message message) {
        if (message == null) {
            return;
        }
        if (message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.zzinz = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zziny = (Messenger)parcelable;
                }
            }
            this.zzj((Intent)message.obj);
            return;
        }
        Log.w((String)"InstanceID/Rpc", (String)"Dropping invalid message");
    }

    private final synchronized void zzi(Intent intent) {
        if (this.zzikb == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzikb = PendingIntent.getBroadcast((Context)this.zzaiq, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzikb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzf(Bundle bundle, String string) throws IOException {
        Intent intent;
        zzaa zzaa2;
        block18: {
            String string2;
            boolean bl;
            block17: {
                zzaa2 = this;
                if (zzaa2.zzikf == null) {
                    zzaa.zzdr(zzaa2.zzaiq);
                    zzaa2.zzikf = new Messenger((Handler)new zzab(zzaa2, Looper.getMainLooper()));
                }
                if (zzins == null) {
                    throw new IOException("MISSING_INSTANCEID_SERVICE");
                }
                Intent intent2 = new Intent(zzint ? "com.google.iid.TOKEN_REQUEST" : "com.google.android.c2dm.intent.REGISTER");
                intent2.setPackage(zzins);
                intent2.putExtras(bundle);
                this.zzi(intent2);
                String string3 = string;
                intent = intent2;
                zzaa2 = this;
                intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string3).length()).append("|ID|").append(string3).append("|").toString());
                intent.putExtra("X-kid", new StringBuilder(5 + String.valueOf(string3).length()).append("|ID|").append(string3).append("|").toString());
                bl = "com.google.android.gsf".equals(zzins);
                String string4 = intent.getStringExtra("useGsf");
                if (string4 != null) {
                    bl = "1".equals(string4);
                }
                if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                    string2 = String.valueOf(intent.getExtras());
                    Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
                }
                if (zzaa2.zziny != null) {
                    intent.putExtra("google.messenger", (Parcelable)zzaa2.zzikf);
                    string2 = Message.obtain();
                    Message.obtain().obj = intent;
                    try {
                        zzaa2.zziny.send((Message)string2);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block17;
                        Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            if (bl) {
                zzaa zzaa3;
                zzaa zzaa4 = zzaa3 = zzaa2;
                synchronized (zzaa3) {
                    if (zzinw == null) {
                        zzinw = new zzac(zzaa3);
                        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                            Log.d((String)"InstanceID/Rpc", (String)"Registered GSF callback receiver");
                        }
                        IntentFilter intentFilter = new IntentFilter("com.google.android.c2dm.intent.REGISTRATION");
                        intentFilter.addCategory(zzaa3.zzaiq.getPackageName());
                        zzaa3.zzaiq.registerReceiver(zzinw, intentFilter, "com.google.android.c2dm.permission.SEND", null);
                    }
                    // ** MonitorExit[var11_11] (shouldn't be in output)
                    zzaa2.zzaiq.sendBroadcast(intent);
                    return;
                }
            }
            intent.putExtra("google.messenger", (Parcelable)zzaa2.zzikf);
            intent.putExtra("messenger2", "1");
            if (zzaa2.zzinz != null) {
                string2 = Message.obtain();
                Message.obtain().obj = intent;
                try {
                    zzaa2.zzinz.send((Message)string2);
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block18;
                    Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                }
            }
        }
        if (zzint) {
            zzaa2.zzaiq.sendBroadcast(intent);
            return;
        }
        zzaa2.zzaiq.startService(intent);
    }

    static String zzy(Bundle bundle) throws IOException {
        if (bundle == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string = bundle.getString("registration_id");
        if (string == null) {
            string = bundle.getString("unregistered");
        }
        if (string == null) {
            string = bundle.getString("error");
            if (string != null) {
                throw new IOException(string);
            }
            String string2 = String.valueOf(bundle);
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Unexpected response from GCM ").append(string2).toString(), (Throwable)new Throwable());
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzae(Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            for (String string : this.zzinx.keySet()) {
                Object object2 = this.zzinx.get(string);
                this.zzinx.put(string, object);
                zzaa.zze(object2, object);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzi(String string, Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Object object2 = this.zzinx.get(string);
            this.zzinx.put(string, object);
            zzaa.zze(object2, object);
            return;
        }
    }

    private static void zze(Object object, Object object2) {
        if (object instanceof ConditionVariable) {
            ((ConditionVariable)object).open();
        }
        if (object instanceof Messenger) {
            Messenger messenger = (Messenger)object;
            Message message = Message.obtain();
            Message.obtain().obj = object2;
            try {
                messenger.send(message);
                return;
            }
            catch (RemoteException remoteException) {
                String string = String.valueOf((Object)remoteException);
                Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(24 + String.valueOf(string).length()).append("Failed to send response ").append(string).toString());
            }
        }
    }

    @Hide
    public final void zzj(Intent intent) {
        if (intent == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Unexpected response: null");
            }
            return;
        }
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string) && !"com.google.android.gms.iid.InstanceID".equals(string)) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string2 = String.valueOf(intent.getAction());
                Log.d((String)"InstanceID/Rpc", (String)(string2.length() != 0 ? "Unexpected response ".concat(string2) : new String("Unexpected response ")));
            }
            return;
        }
        String string3 = intent.getStringExtra("registration_id");
        if (string3 == null) {
            string3 = intent.getStringExtra("unregistered");
        }
        if (string3 == null) {
            Intent intent2 = intent;
            zzaa zzaa2 = this;
            String string4 = intent2.getStringExtra("error");
            if (string4 == null) {
                String string5 = String.valueOf(intent2.getExtras());
                Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(49 + String.valueOf(string5).length()).append("Unexpected response, no error or registration id ").append(string5).toString());
                return;
            }
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string6 = String.valueOf(string4);
                Log.d((String)"InstanceID/Rpc", (String)(string6.length() != 0 ? "Received InstanceID error ".concat(string6) : new String("Received InstanceID error ")));
            }
            String string7 = null;
            if (string4.startsWith("|")) {
                String[] stringArray = string4.split("\\|");
                if (!"ID".equals(stringArray[1])) {
                    String string8 = String.valueOf(string4);
                    Log.w((String)"InstanceID/Rpc", (String)(string8.length() != 0 ? "Unexpected structured response ".concat(string8) : new String("Unexpected structured response ")));
                }
                if (stringArray.length > 2) {
                    string7 = stringArray[2];
                    string4 = stringArray[3];
                    if (string4.startsWith(":")) {
                        string4 = string4.substring(1);
                    }
                } else {
                    string4 = "UNKNOWN";
                }
                intent2.putExtra("error", string4);
            }
            if (string7 == null) {
                zzaa2.zzae(string4);
                return;
            }
            zzaa2.zzi(string7, string4);
            return;
        }
        Matcher matcher = Pattern.compile("\\|ID\\|([^|]+)\\|:?+(.+)").matcher(string3);
        if (!matcher.matches()) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string9 = String.valueOf(string3);
                Log.d((String)"InstanceID/Rpc", (String)(string9.length() != 0 ? "Unexpected response string: ".concat(string9) : new String("Unexpected response string: ")));
            }
            return;
        }
        String string10 = matcher.group(1);
        String string11 = matcher.group(2);
        Bundle bundle = intent.getExtras();
        bundle.putString("registration_id", string11);
        this.zzi(string10, bundle);
    }

    final Bundle zza(Bundle bundle, KeyPair keyPair) throws IOException {
        int n;
        int n2 = n = zzaa.zzds(this.zzaiq);
        KeyPair keyPair2 = keyPair;
        Bundle bundle2 = bundle;
        zzaa zzaa2 = this;
        bundle2.putString("gmsv", Integer.toString(n2));
        bundle2.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle2.putString("app_ver", Integer.toString(InstanceID.zzdo(zzaa2.zzaiq)));
        bundle2.putString("app_ver_name", InstanceID.zzdp(zzaa2.zzaiq));
        bundle2.putString("cliv", "iid-12211000");
        bundle2.putString("appid", InstanceID.zza(keyPair2));
        String string = InstanceID.zzp(keyPair2.getPublic().getEncoded());
        bundle2.putString("pub2", string);
        bundle2.putString("sig", zzaa.zza(keyPair2, zzaa2.zzaiq.getPackageName(), string));
        if (n >= 12000000 && zzinr.get().booleanValue()) {
            Task<Bundle> task = new zzm(this.zzaiq).zzj(1, bundle);
            try {
                return (Bundle)Tasks.await(task);
            }
            catch (InterruptedException | ExecutionException exception) {
                if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                    String string2 = String.valueOf(exception);
                    Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(22 + String.valueOf(string2).length()).append("Error making request: ").append(string2).toString());
                }
                if (exception.getCause() instanceof zzv && ((zzv)exception.getCause()).getErrorCode() == 4) {
                    return this.zzz(bundle);
                }
                return null;
            }
        }
        return this.zzz(bundle);
    }

    private final Bundle zzz(Bundle bundle) throws IOException {
        Bundle bundle2 = this.zzaa(bundle);
        if (bundle2 != null && bundle2.containsKey("google.messenger") && (bundle2 = this.zzaa(bundle)) != null && bundle2.containsKey("google.messenger")) {
            bundle2 = null;
        }
        return bundle2;
    }

    private static synchronized String zzawx() {
        return Integer.toString(zzino++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zzaa(Bundle bundle) throws IOException {
        ConditionVariable conditionVariable = new ConditionVariable();
        String string = zzaa.zzawx();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.zzinx.put(string, conditionVariable);
        }
        this.zzf(bundle, string);
        conditionVariable.block(30000L);
        clazz = this.getClass();
        synchronized (clazz) {
            Object object = this.zzinx.remove(string);
            if (object instanceof Bundle) {
                return (Bundle)object;
            }
            if (object instanceof String) {
                throw new IOException((String)object);
            }
            String string2 = String.valueOf(object);
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(12 + String.valueOf(string2).length()).append("No response ").append(string2).toString());
            throw new IOException("TIMEOUT");
        }
    }
}

