/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.iid.zzd;
import com.google.android.gms.iid.zzf;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;

@Hide
public final class zzh
implements ServiceConnection {
    private final Context zzaiq;
    private final Intent zzimp;
    private final ScheduledExecutorService zzimq;
    private final Queue<zzd> zzimr = new ArrayDeque<zzd>();
    private zzf zzims;
    private boolean zzimt = false;

    public zzh(Context context, String string) {
        this(context, string, new ScheduledThreadPoolExecutor(0));
    }

    @VisibleForTesting
    private zzh(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
        this.zzaiq = context.getApplicationContext();
        this.zzimp = new Intent(string).setPackage(this.zzaiq.getPackageName());
        this.zzimq = scheduledExecutorService;
    }

    public final synchronized void zza(Intent intent, BroadcastReceiver.PendingResult pendingResult) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"new intent queued in the bind-strategy delivery");
        }
        this.zzimr.add(new zzd(intent, pendingResult, this.zzimq));
        this.zzawo();
    }

    private final synchronized void zzawo() {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"flush queue called");
        }
        while (!this.zzimr.isEmpty()) {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"found intent to be delivered");
            }
            if (this.zzims != null && this.zzims.isBinderAlive()) {
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    Log.d((String)"EnhancedIntentService", (String)"binder is alive, sending the intent.");
                }
                zzd zzd2 = this.zzimr.poll();
                this.zzims.zza(zzd2);
                continue;
            }
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                boolean bl = !this.zzimt;
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
            }
            if (!this.zzimt) {
                this.zzimt = true;
                try {
                    if (zza.zzanm().zza(this.zzaiq, this.zzimp, (ServiceConnection)this, 65)) {
                        return;
                    }
                    Log.e((String)"EnhancedIntentService", (String)"binding to the service failed");
                }
                catch (SecurityException securityException) {
                    Log.e((String)"EnhancedIntentService", (String)"Exception while binding the service", (Throwable)securityException);
                }
                while (!this.zzimr.isEmpty()) {
                    this.zzimr.poll().finish();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzh zzh2 = this;
        synchronized (zzh2) {
            this.zzimt = false;
            this.zzims = (zzf)iBinder;
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                String string = String.valueOf(componentName);
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
            }
            this.zzawo();
            return;
        }
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            String string = String.valueOf(componentName);
            Log.d((String)"EnhancedIntentService", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
        }
        this.zzawo();
    }
}

