/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.iid.zzg;
import com.google.android.gms.iid.zzi;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public final class zzk
implements ServiceConnection {
    private final Context zzk;
    private final Intent zzbl;
    private final ScheduledExecutorService zzbm;
    private final Queue<zzg> zzbn = new ArrayDeque<zzg>();
    private zzi zzbo;
    private boolean zzbp = false;

    public zzk(Context context, String string) {
        this(context, string, new ScheduledThreadPoolExecutor(0));
    }

    @VisibleForTesting
    private zzk(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
        this.zzk = context.getApplicationContext();
        this.zzbl = new Intent(string).setPackage(this.zzk.getPackageName());
        this.zzbm = scheduledExecutorService;
    }

    public final synchronized void zzd(Intent intent, BroadcastReceiver.PendingResult pendingResult) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"new intent queued in the bind-strategy delivery");
        }
        this.zzbn.add(new zzg(intent, pendingResult, this.zzbm));
        this.zzl();
    }

    private final synchronized void zzl() {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"flush queue called");
        }
        while (!this.zzbn.isEmpty()) {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"found intent to be delivered");
            }
            if (this.zzbo != null && this.zzbo.isBinderAlive()) {
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    Log.d((String)"EnhancedIntentService", (String)"binder is alive, sending the intent.");
                }
                zzg zzg2 = this.zzbn.poll();
                this.zzbo.zzd(zzg2);
                continue;
            }
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                boolean bl = !this.zzbp;
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
            }
            if (!this.zzbp) {
                this.zzbp = true;
                try {
                    if (ConnectionTracker.getInstance().bindService(this.zzk, this.zzbl, (ServiceConnection)this, 65)) {
                        return;
                    }
                    Log.e((String)"EnhancedIntentService", (String)"binding to the service failed");
                }
                catch (SecurityException securityException) {
                    Log.e((String)"EnhancedIntentService", (String)"Exception while binding the service", (Throwable)securityException);
                }
                while (!this.zzbn.isEmpty()) {
                    this.zzbn.poll().finish();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzk zzk2 = this;
        synchronized (zzk2) {
            this.zzbp = false;
            this.zzbo = (zzi)iBinder;
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                String string = String.valueOf(componentName);
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
            }
            this.zzl();
            return;
        }
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            String string = String.valueOf(componentName);
            Log.d((String)"EnhancedIntentService", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
        }
        this.zzl();
    }
}

