/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.iid.zzaa;
import com.google.android.gms.iid.zzr;
import com.google.android.gms.iid.zzs;
import com.google.android.gms.iid.zzu;
import com.google.android.gms.iid.zzv;
import com.google.android.gms.iid.zzw;
import com.google.android.gms.iid.zzy;
import com.google.android.gms.iid.zzz;
import com.google.android.gms.internal.gcm.zzj;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class zzt
implements ServiceConnection {
    @GuardedBy(value="this")
    int state = 0;
    final Messenger zzch = new Messenger((Handler)new zzj(Looper.getMainLooper(), new zzu(this)));
    zzy zzci;
    @GuardedBy(value="this")
    final Queue<zzz<?>> zzcj = new ArrayDeque();
    @GuardedBy(value="this")
    final SparseArray<zzz<?>> zzck = new SparseArray();
    final /* synthetic */ zzr zzcl;

    private zzt(zzr zzr2) {
        this.zzcl = zzr2;
    }

    final synchronized boolean zze(zzz zzz2) {
        switch (this.state) {
            case 0: {
                this.zzcj.add(zzz2);
                zzt zzt2 = this;
                Preconditions.checkState((zzt2.state == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzt2.state = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!ConnectionTracker.getInstance().bindService(zzr.zzd(zzt2.zzcl), intent, (ServiceConnection)zzt2, 1)) {
                    zzt2.zzd(0, "Unable to bind to service");
                } else {
                    zzr.zze(zzt2.zzcl).schedule(new zzv(zzt2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zzcj.add(zzz2);
                return true;
            }
            case 2: {
                this.zzcj.add(zzz2);
                this.zzt();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zzd(Message message) {
        zzz zzz2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzt zzt2 = this;
        synchronized (zzt2) {
            zzz2 = (zzz)this.zzck.get(n);
            if (zzz2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zzck.remove(n);
            this.zzu();
        }
        Bundle bundle = message.getData();
        zzz zzz3 = zzz2;
        if (bundle.getBoolean("unsupported", false)) {
            zzz3.zzd(new zzaa(4, "Not supported by GmsCore"));
        } else {
            zzz3.zzh(bundle);
        }
        return true;
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        if (iBinder == null) {
            this.zzd(0, "Null service connection");
            return;
        }
        try {
            this.zzci = new zzy(iBinder);
        }
        catch (RemoteException remoteException) {
            this.zzd(0, remoteException.getMessage());
            return;
        }
        this.state = 2;
        this.zzt();
    }

    private final void zzt() {
        zzr.zze(this.zzcl).execute(new zzw(this));
    }

    public final synchronized void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        this.zzd(2, "Service disconnected");
    }

    final synchronized void zzd(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.state) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.state = 4;
                ConnectionTracker.getInstance().unbindService(zzr.zzd(this.zzcl), (ServiceConnection)this);
                zzaa zzaa2 = new zzaa(n, string);
                zzt zzt2 = this;
                Iterator iterator = zzt2.zzcj.iterator();
                while (iterator.hasNext()) {
                    ((zzz)iterator.next()).zzd(zzaa2);
                }
                zzt2.zzcj.clear();
                for (int i = 0; i < zzt2.zzck.size(); ++i) {
                    ((zzz)zzt2.zzck.valueAt(i)).zzd(zzaa2);
                }
                zzt2.zzck.clear();
                return;
            }
            case 3: {
                this.state = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    final synchronized void zzu() {
        if (this.state == 2 && this.zzcj.isEmpty() && this.zzck.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.state = 3;
            ConnectionTracker.getInstance().unbindService(zzr.zzd(this.zzcl), (ServiceConnection)this);
        }
    }

    final synchronized void zzv() {
        if (this.state == 1) {
            this.zzd(1, "Timed out while binding");
        }
    }

    final synchronized void zzg(int n) {
        zzz zzz2 = (zzz)this.zzck.get(n);
        if (zzz2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zzck.remove(n);
            zzz2.zzd(new zzaa(3, "Timed out waiting for response"));
            this.zzu();
        }
    }

    /* synthetic */ zzt(zzr zzr2, zzs zzs2) {
        this(zzr2);
    }
}

