/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.iid.zzak;
import com.google.android.gms.iid.zzd;
import com.google.android.gms.iid.zzo;
import com.google.android.gms.iid.zzp;
import com.google.android.gms.internal.gcm.zzq;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;

final class zzn {
    zzn() {
    }

    @WorkerThread
    final zzo zze(Context context, String string) throws zzp {
        zzo zzo2 = this.zzh(context, string);
        if (zzo2 != null) {
            return zzo2;
        }
        return this.zzf(context, string);
    }

    @WorkerThread
    final zzo zzf(Context context, String string) {
        zzo zzo2 = new zzo(zzd.zzl(), System.currentTimeMillis());
        try {
            zzo zzo3 = this.zzh(context, string);
            if (zzo3 != null) {
                if (Log.isLoggable((String)"InstanceID", (int)3)) {
                    Log.d((String)"InstanceID", (String)"Loaded key after generating new one, using loaded one");
                }
                return zzo3;
            }
        }
        catch (zzp zzp2) {}
        if (Log.isLoggable((String)"InstanceID", (int)3)) {
            Log.d((String)"InstanceID", (String)"Generated new key");
        }
        zzn.zzd(context, string, zzo2);
        this.zze(context, string, zzo2);
        return zzo2;
    }

    static void zzg(Context context, String string) {
        File file = zzn.zzj(context, string);
        if (file.exists()) {
            file.delete();
        }
    }

    static void zzi(Context context) {
        for (File file : zzn.zzj(context).listFiles()) {
            if (!file.getName().startsWith("com.google.InstanceId")) continue;
            file.delete();
        }
    }

    @Nullable
    private final zzo zzh(Context context, String string) throws zzp {
        zzo zzo2;
        Object var3_3 = null;
        try {
            zzo2 = this.zzi(context, string);
            if (zzo2 != null) {
                this.zze(context, string, zzo2);
                return zzo2;
            }
        }
        catch (zzp zzp2) {
            // empty catch block
        }
        try {
            String string2 = string;
            Context context2 = context;
            zzo2 = zzn.zzd(context2.getSharedPreferences("com.google.android.gms.appid", 0), string2);
            if (zzo2 != null) {
                zzn.zzd(context, string, zzo2);
                return zzo2;
            }
        }
        catch (zzp zzp3) {
            // empty catch block
        }
        if (var3_3 != null) {
            throw var3_3;
        }
        return null;
    }

    private static KeyPair zzg(String string, String string2) throws zzp {
        byte[] byArray;
        byte[] byArray2;
        try {
            byArray2 = Base64.decode((String)string, (int)8);
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new zzp(illegalArgumentException);
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray2));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string3 = String.valueOf(generalSecurityException);
            Log.w((String)"InstanceID", (String)new StringBuilder(19 + String.valueOf(string3).length()).append("Invalid key stored ").append(string3).toString());
            throw new zzp(generalSecurityException);
        }
    }

    @Nullable
    private final zzo zzi(Context context, String string) throws zzp {
        File file = zzn.zzj(context, string);
        if (!file.exists()) {
            return null;
        }
        try {
            return zzn.zzd(file);
        }
        catch (IOException iOException) {
            String string2;
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                string2 = String.valueOf(iOException);
                Log.d((String)"InstanceID", (String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to read key from file, retrying: ").append(string2).toString());
            }
            try {
                return zzn.zzd(file);
            }
            catch (IOException iOException2) {
                string2 = String.valueOf(iOException2);
                Log.w((String)"InstanceID", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("IID file exists, but failed to read from it: ").append(string2).toString());
                throw new zzp(iOException2);
            }
        }
    }

    private static void zzd(Context context, String string, zzo zzo2) {
        try {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                Log.d((String)"InstanceID", (String)"Writing key to properties file");
            }
            File file = zzn.zzj(context, string);
            file.createNewFile();
            Properties properties = new Properties();
            properties.setProperty("pub", zzo.zzd(zzo2));
            properties.setProperty("pri", zzo.zze(zzo2));
            properties.setProperty("cre", String.valueOf(zzo.zzf(zzo2)));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                properties.store(fileOutputStream, null);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    zzn.zzd(throwable, fileOutputStream);
                    throw throwable4;
                }
            }
            zzn.zzd(null, fileOutputStream);
            return;
        }
        catch (IOException iOException) {
            String string2 = String.valueOf(iOException);
            Log.w((String)"InstanceID", (String)new StringBuilder(21 + String.valueOf(string2).length()).append("Failed to write key: ").append(string2).toString());
            return;
        }
    }

    private static File zzj(Context context) {
        File file = ContextCompat.getNoBackupFilesDir((Context)context);
        if (file != null && file.isDirectory()) {
            return file;
        }
        Log.w((String)"InstanceID", (String)"noBackupFilesDir doesn't exist, using regular files directory instead");
        return context.getFilesDir();
    }

    private static File zzj(Context context, String string) {
        String string2;
        if (TextUtils.isEmpty((CharSequence)string)) {
            string2 = "com.google.InstanceId.properties";
        } else {
            try {
                String string3 = Base64.encodeToString((byte[])string.getBytes("UTF-8"), (int)11);
                string2 = new StringBuilder(33 + String.valueOf(string3).length()).append("com.google.InstanceId_").append(string3).append(".properties").toString();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
        }
        return new File(zzn.zzj(context), string2);
    }

    @Nullable
    private static zzo zzd(File file) throws zzp, IOException {
        zzo zzo2;
        String string;
        String string2;
        Serializable serializable;
        Throwable throwable;
        FileInputStream fileInputStream;
        block7: {
            fileInputStream = new FileInputStream(file);
            throwable = null;
            serializable = new Properties();
            ((Properties)serializable).load(fileInputStream);
            string2 = ((Properties)serializable).getProperty("pub");
            string = ((Properties)serializable).getProperty("pri");
            if (string2 != null && string != null) break block7;
            zzn.zzd(null, fileInputStream);
            return null;
        }
        try {
            long l;
            KeyPair keyPair = zzn.zzg(string2, string);
            try {
                l = Long.parseLong(((Properties)serializable).getProperty("cre"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new zzp(numberFormatException);
            }
            zzo2 = new zzo(keyPair, l);
        }
        catch (Throwable throwable2) {
            try {
                serializable = throwable2;
                throwable = throwable2;
                throw serializable;
            }
            catch (Throwable throwable3) {
                zzn.zzd(throwable, fileInputStream);
                throw throwable3;
            }
        }
        zzn.zzd(null, fileInputStream);
        return zzo2;
    }

    @Nullable
    private static zzo zzd(SharedPreferences sharedPreferences, String string) throws zzp {
        String string2 = sharedPreferences.getString(zzak.zzh(string, "|P|"), null);
        String string3 = sharedPreferences.getString(zzak.zzh(string, "|K|"), null);
        if (string2 == null || string3 == null) {
            return null;
        }
        KeyPair keyPair = zzn.zzg(string2, string3);
        long l = zzn.zze(sharedPreferences, string);
        return new zzo(keyPair, l);
    }

    private final void zze(Context context, String string, zzo zzo2) {
        zzo zzo3;
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.appid", 0);
        try {
            zzo3 = zzn.zzd(sharedPreferences, string);
            if (zzo2.equals(zzo3)) {
                return;
            }
        }
        catch (zzp zzp2) {}
        if (Log.isLoggable((String)"InstanceID", (int)3)) {
            Log.d((String)"InstanceID", (String)"Writing key to shared preferences");
        }
        zzo3 = sharedPreferences.edit();
        zzo3.putString(zzak.zzh(string, "|P|"), zzo.zzd(zzo2));
        zzo3.putString(zzak.zzh(string, "|K|"), zzo.zze(zzo2));
        zzo3.putString(zzak.zzh(string, "cre"), String.valueOf(zzo.zzf(zzo2)));
        zzo3.commit();
    }

    private static long zze(SharedPreferences sharedPreferences, String string) {
        String string2 = sharedPreferences.getString(zzak.zzh(string, "cre"), null);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }

    private static /* synthetic */ void zzd(Throwable throwable, FileOutputStream fileOutputStream) {
        if (throwable != null) {
            try {
                fileOutputStream.close();
                return;
            }
            catch (Throwable throwable2) {
                zzq.zzd(throwable, throwable2);
                return;
            }
        }
        fileOutputStream.close();
    }

    private static /* synthetic */ void zzd(Throwable throwable, FileInputStream fileInputStream) {
        if (throwable != null) {
            try {
                fileInputStream.close();
                return;
            }
            catch (Throwable throwable2) {
                zzq.zzd(throwable, throwable2);
                return;
            }
        }
        fileInputStream.close();
    }
}

