/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ProviderInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.internal.zzaqv;
import com.google.android.gms.internal.zzarp;

public class zzare {
    private static Boolean zzbiI = null;
    private static ContentProviderClient zzbiJ;

    @TargetApi(value=11)
    private static Intent zza(Context context, String string, Parcelable parcelable, boolean bl) {
        Bundle bundle;
        if (context == null || string == null) {
            throw new IllegalArgumentException("Parameter is null");
        }
        if (!zzare.zzbD(context)) {
            return null;
        }
        Bundle bundle2 = null;
        if (parcelable != null) {
            bundle2 = new Bundle(1);
            bundle2.putParcelable("key_fallbackIntent", parcelable);
        }
        try {
            bundle = zzare.zza(context, "method_getInstantAppIntent", string, bundle2);
        }
        catch (DeadObjectException deadObjectException) {
            Log.e((String)"InstantAppsApi", (String)String.format("While calling %s %s:\n", zzaqv.zzbiv, "method_getInstantAppIntent"), (Throwable)deadObjectException);
            zzare.reset();
            if (bl) {
                return zzare.zza(context, string, parcelable, false);
            }
            return null;
        }
        catch (RemoteException | IllegalArgumentException throwable) {
            Log.e((String)"InstantAppsApi", (String)String.format("While calling %s %s:\n", zzaqv.zzbiv, "method_getInstantAppIntent"), (Throwable)throwable);
            return null;
        }
        if (bundle == null) {
            return null;
        }
        return (Intent)bundle.getParcelable("key_instantAppIntent");
    }

    @TargetApi(value=17)
    private static synchronized boolean zzbC(Context context) {
        if (zzbiJ == null) {
            zzbiJ = context.getApplicationContext().getContentResolver().acquireUnstableContentProviderClient(zzaqv.zzbiv);
        }
        return zzbiJ != null;
    }

    @TargetApi(value=17)
    private static synchronized Bundle zzd(String string, String string2, Bundle bundle) throws RemoteException {
        return zzbiJ.call(string, string2, bundle);
    }

    @TargetApi(value=11)
    private static synchronized Bundle zza(Context context, String string, String string2, Bundle bundle) throws RemoteException {
        if (zzbiJ == null) {
            return context.getContentResolver().call(zzaqv.zzbiv, string, string2, bundle);
        }
        return zzare.zzd(string, string2, bundle);
    }

    static Intent getInstantAppIntent(Context context, String string, Intent intent) {
        return zzare.zza(context, string, (Parcelable)intent, true);
    }

    @TargetApi(value=11)
    static synchronized boolean zzbD(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Parameter is null");
        }
        if (zzbiI != null) {
            return zzbiI;
        }
        zzbiI = zzare.zzbE(context);
        return zzbiI;
    }

    private static synchronized boolean zzbE(Context context) {
        if (!zzarp.zzbH(context)) {
            return false;
        }
        ProviderInfo providerInfo = context.getPackageManager().resolveContentProvider(zzaqv.zzbiv.getAuthority(), 0);
        if (providerInfo == null) {
            return false;
        }
        if (!providerInfo.packageName.equals("com.google.android.gms")) {
            String string = String.valueOf(providerInfo.packageName);
            Log.e((String)"InstantAppsApi", (String)(string.length() != 0 ? "Incorrect package name for instant apps content provider: ".concat(string) : new String("Incorrect package name for instant apps content provider: ")));
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || zzare.zzbC(context);
    }

    static synchronized void reset() {
        if (zzbiJ != null) {
            zzbiJ.release();
            zzbiJ = null;
        }
        zzbiI = null;
    }
}

