/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.instantapps.PackageManagerWrapper;
import com.google.android.gms.internal.zzbik;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdb;

public final class zzcdd
implements PackageManagerWrapper {
    private static zzcdd zzbhw;
    private final Context zzqG;
    private final boolean zzbhx;

    public static synchronized zzcdd zzi(Context context, boolean bl) {
        Context context2 = context.getApplicationContext();
        if (zzbhw == null || zzcdd.zzbhw.zzqG != context2 || zzcdd.zzbhw.zzbhx != bl) {
            zzbhw = new zzcdd(context2, bl);
        }
        return zzbhw;
    }

    private zzcdd(Context context, boolean bl) {
        this.zzqG = context;
        this.zzbhx = bl;
    }

    @Override
    public final String[] getPackagesForUid(int n) {
        String[] stringArray;
        if (this.zzbhx && (stringArray = this.zzqG.getPackageManager().getPackagesForUid(n)) != null) {
            return stringArray;
        }
        stringArray = zzcdb.zzbf(this.zzqG);
        if (stringArray != null) {
            try {
                String string = stringArray.zzbh(n);
                if (string == null) {
                    return null;
                }
                return new String[]{string};
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting app package for UID", (Throwable)remoteException);
                return null;
            }
        }
        return null;
    }

    @Override
    public final PackageInfo getPackageInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzcdb zzcdb2;
        if (this.zzbhx) {
            try {
                return this.zzqG.getPackageManager().getPackageInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzcdb2 = zzcdb.zzbf(this.zzqG)) != null) {
            try {
                PackageInfo packageInfo = zzcdb2.getPackageInfo(string, n);
                if (packageInfo != null) {
                    return packageInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting package info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final ApplicationInfo getApplicationInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzcdb zzcdb2;
        if (this.zzbhx) {
            try {
                return this.zzqG.getPackageManager().getApplicationInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzcdb2 = zzcdb.zzbf(this.zzqG)) != null) {
            try {
                ApplicationInfo applicationInfo = zzcdb2.getApplicationInfo(string, n);
                if (applicationInfo != null) {
                    return applicationInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
        if (this.zzbhx && this.zzqG.getPackageManager().getPackagesForUid(applicationInfo.uid) != null) {
            return this.zzqG.getPackageManager().getApplicationLabel(applicationInfo);
        }
        zzcdb zzcdb2 = zzcdb.zzbf(this.zzqG);
        if (zzcdb2 != null) {
            try {
                return zzcdb2.zzdu(applicationInfo.packageName);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application label", (Throwable)remoteException);
            }
        }
        return null;
    }

    @Override
    public final String getCallingPackage(Activity activity) {
        return new zzccw(activity).getCallingPackage();
    }

    @Override
    public final ComponentName getCallingActivity(Activity activity) {
        return new zzccw(activity).getCallingActivity();
    }

    @Override
    public final boolean isInstantApp() {
        return this.isInstantApp(this.zzqG.getPackageName());
    }

    @Override
    public final boolean isInstantApp(String string) {
        zzcdb zzcdb2 = zzcdb.zzbf(this.zzqG);
        if (zzcdb2 != null) {
            try {
                return zzcdb2.isInstantApp(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error checking if app is instant app", (Throwable)remoteException);
            }
        }
        return false;
    }

    @Override
    public final boolean isInstantApp(int n) {
        if (Process.myUid() == n) {
            return zzbik.zzaN((Context)this.zzqG);
        }
        zzcdb zzcdb2 = zzcdb.zzbf(this.zzqG);
        if (zzcdb2 != null) {
            try {
                return zzcdb2.zzbh(n) != null;
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error checking if app is instant app", (Throwable)remoteException);
            }
        }
        return false;
    }
}

