/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.instantapps.PackageManagerWrapper;
import com.google.android.gms.internal.zzbgx;
import com.google.android.gms.internal.zzcbj;
import com.google.android.gms.internal.zzcbo;

public final class zzcbq
implements PackageManagerWrapper {
    private static zzcbq zzbhs;
    private final Context zzqF;
    private final boolean zzbht;

    public static synchronized zzcbq zzi(Context context, boolean bl) {
        Context context2 = context.getApplicationContext();
        if (zzbhs == null || zzcbq.zzbhs.zzqF != context2 || zzcbq.zzbhs.zzbht != bl) {
            zzbhs = new zzcbq(context2, bl);
        }
        return zzbhs;
    }

    private zzcbq(Context context, boolean bl) {
        this.zzqF = context;
        this.zzbht = bl;
    }

    @Override
    public final String[] getPackagesForUid(int n) {
        String[] stringArray;
        if (this.zzbht && (stringArray = this.zzqF.getPackageManager().getPackagesForUid(n)) != null) {
            return stringArray;
        }
        stringArray = zzcbo.zzbf(this.zzqF);
        if (stringArray != null) {
            try {
                String string = stringArray.zzbi(n);
                if (string == null) {
                    return null;
                }
                return new String[]{string};
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting app package for UID", (Throwable)remoteException);
                return null;
            }
        }
        return null;
    }

    @Override
    public final PackageInfo getPackageInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzcbo zzcbo2;
        if (this.zzbht) {
            try {
                return this.zzqF.getPackageManager().getPackageInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzcbo2 = zzcbo.zzbf(this.zzqF)) != null) {
            try {
                PackageInfo packageInfo = zzcbo2.getPackageInfo(string, n);
                if (packageInfo != null) {
                    return packageInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting package info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final ApplicationInfo getApplicationInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzcbo zzcbo2;
        if (this.zzbht) {
            try {
                return this.zzqF.getPackageManager().getApplicationInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzcbo2 = zzcbo.zzbf(this.zzqF)) != null) {
            try {
                ApplicationInfo applicationInfo = zzcbo2.getApplicationInfo(string, n);
                if (applicationInfo != null) {
                    return applicationInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
        if (this.zzbht && this.zzqF.getPackageManager().getPackagesForUid(applicationInfo.uid) != null) {
            return this.zzqF.getPackageManager().getApplicationLabel(applicationInfo);
        }
        zzcbo zzcbo2 = zzcbo.zzbf(this.zzqF);
        if (zzcbo2 != null) {
            try {
                return zzcbo2.zzdt(applicationInfo.packageName);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application label", (Throwable)remoteException);
            }
        }
        return null;
    }

    @Override
    public final String getCallingPackage(Activity activity) {
        return new zzcbj(activity).getCallingPackage();
    }

    @Override
    public final ComponentName getCallingActivity(Activity activity) {
        return new zzcbj(activity).getCallingActivity();
    }

    @Override
    public final boolean isInstantApp() {
        return this.isInstantApp(this.zzqF.getPackageName());
    }

    @Override
    public final boolean isInstantApp(String string) {
        zzcbo zzcbo2 = zzcbo.zzbf(this.zzqF);
        if (zzcbo2 != null) {
            try {
                return zzcbo2.isInstantApp(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error checking if app is instant app", (Throwable)remoteException);
            }
        }
        return false;
    }

    @Override
    public final boolean isInstantApp(int n) {
        if (Process.myUid() == n) {
            return zzbgx.zzaN((Context)this.zzqF);
        }
        zzcbo zzcbo2 = zzcbo.zzbf(this.zzqF);
        if (zzcbo2 != null) {
            try {
                return zzcbo2.zzbi(n) != null;
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error checking if app is instant app", (Throwable)remoteException);
            }
        }
        return false;
    }
}

