/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.instantapps.PackageManagerCompat;
import com.google.android.gms.internal.zzbxe;

public final class zzbxi
implements PackageManagerCompat {
    private static zzbxi zzhvr;
    private final Context zzaie;
    private final boolean zzhvs;

    public static synchronized zzbxi zzi(Context context, boolean bl) {
        Context context2 = context.getApplicationContext();
        if (zzhvr == null || zzbxi.zzhvr.zzaie != context2 || !zzbxi.zzhvr.zzhvs) {
            zzhvr = new zzbxi(context2, true);
        }
        return zzhvr;
    }

    private zzbxi(Context context, boolean bl) {
        this.zzaie = context;
        this.zzhvs = true;
    }

    @Override
    public final String[] getPackagesForUid(int n) {
        String[] stringArray;
        if (this.zzhvs && (stringArray = this.zzaie.getPackageManager().getPackagesForUid(n)) != null) {
            return stringArray;
        }
        stringArray = zzbxe.zzdi(this.zzaie);
        if (stringArray != null) {
            try {
                String string = stringArray.zzdm(n);
                if (string == null) {
                    return null;
                }
                return new String[]{string};
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting app package for UID", (Throwable)remoteException);
                return null;
            }
        }
        return null;
    }

    @Override
    public final PackageInfo getPackageInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzbxe zzbxe2;
        if (this.zzhvs) {
            try {
                return this.zzaie.getPackageManager().getPackageInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzbxe2 = zzbxe.zzdi(this.zzaie)) != null) {
            try {
                PackageInfo packageInfo = zzbxe2.getPackageInfo(string, n);
                if (packageInfo != null) {
                    return packageInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting package info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final ApplicationInfo getApplicationInfo(String string, int n) throws PackageManager.NameNotFoundException {
        zzbxe zzbxe2;
        if (this.zzhvs) {
            try {
                return this.zzaie.getPackageManager().getApplicationInfo(string, n);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((zzbxe2 = zzbxe.zzdi(this.zzaie)) != null) {
            try {
                ApplicationInfo applicationInfo = zzbxe2.getApplicationInfo(string, n);
                if (applicationInfo != null) {
                    return applicationInfo;
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application info", (Throwable)remoteException);
            }
        }
        throw new PackageManager.NameNotFoundException();
    }

    @Override
    public final CharSequence getApplicationLabel(ApplicationInfo applicationInfo) {
        if (this.zzhvs && this.zzaie.getPackageManager().getPackagesForUid(applicationInfo.uid) != null) {
            return this.zzaie.getPackageManager().getApplicationLabel(applicationInfo);
        }
        zzbxe zzbxe2 = zzbxe.zzdi(this.zzaie);
        if (zzbxe2 != null) {
            try {
                return zzbxe2.zzhx(applicationInfo.packageName);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting application label", (Throwable)remoteException);
            }
        }
        return null;
    }

    @Override
    public final String getInstallerPackageName(String string) {
        zzbxe zzbxe2;
        IllegalArgumentException illegalArgumentException = null;
        if (this.zzhvs) {
            try {
                return this.zzaie.getPackageManager().getInstallerPackageName(string);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                // empty catch block
            }
        }
        if ((zzbxe2 = zzbxe.zzdi(this.zzaie)) != null) {
            try {
                if (zzbxe2.zzhw(string) != 0) {
                    return "com.android.vending";
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error getting UID for app package", (Throwable)remoteException);
            }
        }
        throw illegalArgumentException == null ? new IllegalArgumentException() : illegalArgumentException;
    }

    @Override
    public final boolean isInstantApp() {
        return this.isInstantApp(this.zzaie.getPackageName());
    }

    @Override
    public final boolean isInstantApp(String string) {
        zzbxe zzbxe2 = zzbxe.zzdi(this.zzaie);
        if (zzbxe2 != null) {
            try {
                return zzbxe2.isInstantApp(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error checking if app is instant app", (Throwable)remoteException);
            }
        }
        return false;
    }

    @Override
    public final int getInstantAppCookieMaxSize() {
        zzbxe zzbxe2 = zzbxe.zzdi(this.zzaie);
        if (zzbxe2 != null) {
            try {
                return zzbxe2.getInstantAppCookieMaxSize();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error fetching max cookie size", (Throwable)remoteException);
            }
        }
        return 0;
    }

    @Override
    public final boolean setInstantAppCookie(byte[] byArray) {
        zzbxe zzbxe2 = zzbxe.zzdi(this.zzaie);
        if (zzbxe2 != null) {
            try {
                return zzbxe2.zza(Process.myUid(), byArray);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error setting cookie", (Throwable)remoteException);
            }
        }
        return false;
    }

    @Override
    public final byte[] getInstantAppCookie() {
        zzbxe zzbxe2 = zzbxe.zzdi(this.zzaie);
        if (zzbxe2 != null) {
            try {
                return zzbxe2.zzdn(Process.myUid());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"InstantAppsPMW", (String)"Error setting cookie", (Throwable)remoteException);
            }
        }
        return null;
    }
}

