/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.ProviderInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.zzcdc;
import com.google.android.gms.internal.zzcdm;

public final class zzcdb {
    private static zzcdb zzihk;
    private final Context mContext;

    @Nullable
    public static synchronized zzcdb zzdr(Context context) {
        if (zzihk == null) {
            zzcdb zzcdb2;
            Context context2 = context.getApplicationContext();
            if (!(Build.VERSION.SDK_INT >= 16)) {
                zzcdb2 = null;
            } else if (!zzcdm.zzds(context2)) {
                zzcdb2 = null;
            } else {
                ProviderInfo providerInfo = context2.getPackageManager().resolveContentProvider(zzcdc.zzihl.getAuthority(), 0);
                if (providerInfo == null) {
                    zzcdb2 = null;
                } else if (!providerInfo.packageName.equals("com.google.android.gms")) {
                    String string = providerInfo.packageName;
                    Log.e((String)"IAMetadataClient", (String)new StringBuilder(85 + String.valueOf(string).length()).append("Package ").append(string).append(" is invalid for instant apps content provider; instant apps will be disabled.").toString());
                    zzcdb2 = null;
                } else {
                    zzcdb2 = new zzcdb(context2);
                }
            }
            zzihk = zzcdb2;
        }
        return zzihk;
    }

    private zzcdb(Context context) {
        this.mContext = context;
    }

    @TargetApi(value=16)
    private final Bundle zzg(String string, Bundle bundle) throws RemoteException {
        Bundle bundle2;
        long l = Binder.clearCallingIdentity();
        try {
            bundle2 = this.mContext.getContentResolver().call(zzcdc.zzihl, string, null, bundle);
        }
        finally {
            Binder.restoreCallingIdentity((long)l);
        }
        if (bundle2 == null) {
            throw new RemoteException();
        }
        return bundle2;
    }

    public final String zzdt(int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putInt("uid", n);
        return this.zzg("getAppPackageForUid", bundle).getString("result");
    }

    public final int zzic(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        return this.zzg("getUidForPackage", bundle).getInt("result");
    }

    public final ApplicationInfo getApplicationInfo(String string, int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        bundle.putInt("flags", n);
        return (ApplicationInfo)this.zzg("getWHApplicationInfo", bundle).getParcelable("result");
    }

    public final PackageInfo getPackageInfo(String string, int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        bundle.putInt("flags", n);
        return (PackageInfo)this.zzg("getWHPackageInfo", bundle).getParcelable("result");
    }

    public final String zzid(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        return this.zzg("getApplicationLabel", bundle).getString("result");
    }

    public final ComponentName zzie(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("shadowActivity", string);
        return (ComponentName)this.zzg("getCallingActivity", bundle).getParcelable("result");
    }

    public final boolean isInstantApp(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        return this.zzg("isInstantApp", bundle).getBoolean("result");
    }

    public final int getInstantAppCookieMaxSize() throws RemoteException {
        return this.zzg("getInstantAppCookieMaxSize", new Bundle()).getInt("result");
    }

    public final boolean zza(int n, byte[] byArray) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putInt("uid", n);
        bundle.putByteArray("cookie", byArray);
        return this.zzg("setInstantAppCookie", bundle).getBoolean("result");
    }

    public final byte[] zzdu(int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putInt("uid", n);
        return this.zzg("getInstantAppCookie", bundle).getByteArray("result");
    }
}

