/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.ProviderInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.zzcew;
import com.google.android.gms.internal.zzcfh;

public final class zzcev {
    private static zzcev zza;
    private final Context zzb;

    @Nullable
    public static synchronized zzcev zza(Context context) {
        if (zza == null) {
            zzcev zzcev2;
            Context context2 = context.getApplicationContext();
            if (!(Build.VERSION.SDK_INT >= 16)) {
                zzcev2 = null;
            } else if (!zzcfh.zza(context2)) {
                zzcev2 = null;
            } else {
                ProviderInfo providerInfo = context2.getPackageManager().resolveContentProvider(zzcew.zza.getAuthority(), 0);
                if (providerInfo == null) {
                    zzcev2 = null;
                } else if (!providerInfo.packageName.equals("com.google.android.gms")) {
                    String string = providerInfo.packageName;
                    Log.e((String)"IAMetadataClient", (String)new StringBuilder(85 + String.valueOf(string).length()).append("Package ").append(string).append(" is invalid for instant apps content provider; instant apps will be disabled.").toString());
                    zzcev2 = null;
                } else {
                    zzcev2 = new zzcev(context2);
                }
            }
            zza = zzcev2;
        }
        return zza;
    }

    private zzcev(Context context) {
        this.zzb = context;
    }

    @TargetApi(value=16)
    private final Bundle zza(String string, Bundle bundle) throws RemoteException {
        Bundle bundle2;
        long l = Binder.clearCallingIdentity();
        try {
            bundle2 = this.zzb.getContentResolver().call(zzcew.zza, string, null, bundle);
        }
        finally {
            Binder.restoreCallingIdentity((long)l);
        }
        if (bundle2 == null) {
            throw new RemoteException();
        }
        return bundle2;
    }

    public final String zza(int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putInt("uid", n);
        return this.zza("getAppPackageForUid", bundle).getString("result");
    }

    public final int zza(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        return this.zza("getUidForPackage", bundle).getInt("result");
    }

    public final ApplicationInfo zza(String string, int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        bundle.putInt("flags", n);
        return (ApplicationInfo)this.zza("getWHApplicationInfo", bundle).getParcelable("result");
    }

    public final PackageInfo zzb(String string, int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        bundle.putInt("flags", n);
        return (PackageInfo)this.zza("getWHPackageInfo", bundle).getParcelable("result");
    }

    public final String zzb(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        return this.zza("getApplicationLabel", bundle).getString("result");
    }

    public final ComponentName zzc(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("shadowActivity", string);
        return (ComponentName)this.zza("getCallingActivity", bundle).getParcelable("result");
    }

    public final boolean zzd(String string) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("packageName", string);
        return this.zza("isInstantApp", bundle).getBoolean("result");
    }

    public final int zza() throws RemoteException {
        return this.zza("getInstantAppCookieMaxSize", new Bundle()).getInt("result");
    }

    public final boolean zza(int n, byte[] byArray) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putInt("uid", n);
        bundle.putByteArray("cookie", byArray);
        return this.zza("setInstantAppCookie", bundle).getBoolean("result");
    }

    public final byte[] zzb(int n) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putInt("uid", n);
        return this.zza("getInstantAppCookie", bundle).getByteArray("result");
    }
}

