/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ProviderInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.instantapps.InstantAppIntentData;
import com.google.android.gms.internal.zzbgq;
import com.google.android.gms.internal.zzcdz;
import com.google.android.gms.internal.zzcec;
import com.google.android.gms.internal.zzcfh;
import com.google.android.gms.internal.zzdoi;
import com.google.android.gms.internal.zzdoj;
import com.google.android.gms.internal.zzflr;
import com.google.android.gms.internal.zzfls;
import java.util.ArrayList;
import java.util.Collections;

public final class zzceu {
    private static Boolean zzipq = null;
    private static ContentProviderClient zzipr;

    @TargetApi(value=11)
    private static InstantAppIntentData zza(Context context, String string, Parcelable parcelable, boolean bl) {
        Bundle bundle;
        zzdoj zzdoj2;
        while (true) {
            if (context == null || string == null) {
                throw new IllegalArgumentException("Parameter is null");
            }
            zzdoj2 = zzcec.zzed(1401);
            if (!zzceu.zzdu(context)) {
                return InstantAppIntentData.zziod;
            }
            Bundle bundle2 = null;
            if (parcelable != null) {
                bundle2 = new Bundle(1);
                bundle2.putParcelable("key_fallbackIntent", parcelable);
            }
            try {
                bundle = zzceu.zza(context, "method_getInstantAppIntentData", string, bundle2);
            }
            catch (DeadObjectException deadObjectException) {
                Log.e((String)"InstantAppsApi", (String)String.format("While calling %s %s:\n", zzcdz.zzioz, "method_getInstantAppIntentData"), (Throwable)deadObjectException);
                zzceu.reset();
                if (bl) {
                    bl = false;
                    continue;
                }
                return InstantAppIntentData.zziod;
            }
            catch (RemoteException | IllegalArgumentException throwable) {
                Log.e((String)"InstantAppsApi", (String)String.format("While calling %s %s:\n", zzcdz.zzioz, "method_getInstantAppIntentData"), (Throwable)throwable);
                return InstantAppIntentData.zziod;
            }
            break;
        }
        if (bundle == null) {
            return InstantAppIntentData.zziod;
        }
        byte[] byArray = bundle.getByteArray("key_instantAppIntentData");
        if (byArray == null) {
            return InstantAppIntentData.zziod;
        }
        InstantAppIntentData instantAppIntentData = (InstantAppIntentData)zzbgq.zza((byte[])byArray, InstantAppIntentData.CREATOR);
        if (instantAppIntentData != null && instantAppIntentData.getIntent() != null && instantAppIntentData.getIntent().hasExtra("key_eventListProtoBytes")) {
            zzdoj zzdoj3 = zzcec.zzed(1402);
            zzdoj zzdoj4 = zzdoj2;
            Intent intent = instantAppIntentData.getIntent();
            byte[] byArray2 = intent.getByteArrayExtra("key_eventListProtoBytes");
            zzdoi zzdoi2 = null;
            if (byArray2 != null) {
                try {
                    byte[] byArray3 = byArray2;
                    zzdoi2 = (zzdoi)zzfls.zza((zzfls)new zzdoi(), (byte[])byArray3);
                }
                catch (zzflr zzflr2) {
                    Log.e((String)"EventLogHelper", (String)"Could not read event list proto", (Throwable)zzflr2);
                }
            }
            if (zzdoi2 == null) {
                zzdoi2 = new zzdoi();
                new zzdoi().zzlyl = new zzdoj[]{zzdoj4, zzdoj3};
            } else {
                int n = zzdoi2.zzlyl.length + 2;
                ArrayList<zzdoj> arrayList = new ArrayList<zzdoj>(n);
                arrayList.add(zzdoj4);
                Collections.addAll(arrayList, zzdoi2.zzlyl);
                arrayList.add(zzdoj3);
                zzdoi2.zzlyl = arrayList.toArray(new zzdoj[n]);
            }
            intent.putExtra("key_eventListProtoBytes", zzdoi.zzc((zzfls)zzdoi2));
        }
        return instantAppIntentData;
    }

    @TargetApi(value=17)
    private static synchronized boolean zzdt(Context context) {
        if (zzipr == null) {
            zzipr = context.getApplicationContext().getContentResolver().acquireUnstableContentProviderClient(zzcdz.zzioz);
        }
        return zzipr != null;
    }

    @TargetApi(value=17)
    private static synchronized Bundle zzc(String string, String string2, Bundle bundle) throws RemoteException {
        return zzipr.call(string, string2, bundle);
    }

    @TargetApi(value=11)
    private static synchronized Bundle zza(Context context, String string, String string2, Bundle bundle) throws RemoteException {
        if (zzipr == null) {
            return context.getContentResolver().call(zzcdz.zzioz, string, string2, bundle);
        }
        return zzceu.zzc(string, string2, bundle);
    }

    static InstantAppIntentData zza(Context context, String string, Intent intent) {
        return zzceu.zza(context, string, (Parcelable)intent, true);
    }

    @TargetApi(value=11)
    static synchronized boolean zzdu(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Parameter is null");
        }
        if (zzipq != null) {
            return zzipq;
        }
        zzipq = zzceu.zzdv(context);
        return zzipq;
    }

    private static synchronized boolean zzdv(Context context) {
        if (!zzcfh.zzdy(context)) {
            return false;
        }
        ProviderInfo providerInfo = context.getPackageManager().resolveContentProvider(zzcdz.zzioz.getAuthority(), 0);
        if (providerInfo == null) {
            return false;
        }
        if (!providerInfo.packageName.equals("com.google.android.gms")) {
            String string = String.valueOf(providerInfo.packageName);
            Log.e((String)"InstantAppsApi", (String)(string.length() != 0 ? "Incorrect package name for instant apps content provider: ".concat(string) : new String("Incorrect package name for instant apps content provider: ")));
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || zzceu.zzdt(context);
    }

    private static synchronized void reset() {
        if (zzipr != null) {
            zzipr.release();
            zzipr = null;
        }
        zzipq = null;
    }
}

