/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import com.google.android.gms.internal.zzarz;
import com.google.android.gms.location.Geofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingEvent {
    private final int zzPF;
    private final int zzbji;
    private final List<Geofence> zzbjj;
    private final Location zzbjk;

    private GeofencingEvent(int n, int n2, List<Geofence> list, Location location) {
        this.zzPF = n;
        this.zzbji = n2;
        this.zzbjj = list;
        this.zzbjk = location;
    }

    public static GeofencingEvent fromIntent(Intent intent) {
        if (intent == null) {
            return null;
        }
        int n = intent.getIntExtra("gms_error_code", -1);
        int n2 = GeofencingEvent.zzA(intent);
        List<Geofence> list = GeofencingEvent.zzB(intent);
        Location location = (Location)intent.getParcelableExtra("com.google.android.location.intent.extra.triggering_location");
        return new GeofencingEvent(n, n2, list, location);
    }

    private static int zzA(Intent intent) {
        int n = intent.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        if (n == -1) {
            return -1;
        }
        if (n == 1 || n == 2 || n == 4) {
            return n;
        }
        return -1;
    }

    private static List<Geofence> zzB(Intent intent) {
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("com.google.android.location.intent.extra.geofence_list");
        if (arrayList == null) {
            return null;
        }
        ArrayList<Geofence> arrayList2 = new ArrayList<Geofence>(arrayList.size());
        for (byte[] byArray : arrayList) {
            arrayList2.add(zzarz.zzw(byArray));
        }
        return arrayList2;
    }

    public boolean hasError() {
        return this.zzPF != -1;
    }

    public int getErrorCode() {
        return this.zzPF;
    }

    public int getGeofenceTransition() {
        return this.zzbji;
    }

    public List<Geofence> getTriggeringGeofences() {
        return this.zzbjj;
    }

    public Location getTriggeringLocation() {
        return this.zzbjk;
    }
}

