/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.internal.zzasa;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

public class zzarz
extends zza
implements Geofence {
    private final int mVersionCode;
    private final String zzOn;
    private final long zzbkw;
    private final short zzbjc;
    private final double zzbjd;
    private final double zzbje;
    private final float zzbjf;
    private final int zzbja;
    private final int zzbjg;
    private final int zzbjh;
    public static final Parcelable.Creator<zzarz> CREATOR = new zzasa();

    public zzarz(int n, String string, int n2, short s, double d, double d2, float f, long l, int n3, int n4) {
        zzarz.zzeX(string);
        zzarz.zzf(f);
        zzarz.zza(d, d2);
        n2 = zzarz.zzks(n2);
        this.mVersionCode = n;
        this.zzbjc = s;
        this.zzOn = string;
        this.zzbjd = d;
        this.zzbje = d2;
        this.zzbjf = f;
        this.zzbkw = l;
        this.zzbja = n2;
        this.zzbjg = n3;
        this.zzbjh = n4;
    }

    public zzarz(String string, int n, short s, double d, double d2, float f, long l, int n2, int n3) {
        this(1, string, n, s, d, d2, f, l, n2, n3);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public short zzHG() {
        return this.zzbjc;
    }

    public double getLatitude() {
        return this.zzbjd;
    }

    public double getLongitude() {
        return this.zzbje;
    }

    public float getRadius() {
        return this.zzbjf;
    }

    @Override
    public String getRequestId() {
        return this.zzOn;
    }

    public long getExpirationTime() {
        return this.zzbkw;
    }

    public int zzHH() {
        return this.zzbja;
    }

    public int zzHI() {
        return this.zzbjg;
    }

    public int zzHJ() {
        return this.zzbjh;
    }

    private static void zzeX(String string) {
        if (string == null || string.length() > 100) {
            String string2 = String.valueOf(string);
            throw new IllegalArgumentException(string2.length() != 0 ? "requestId is null or too long: ".concat(string2) : new String("requestId is null or too long: "));
        }
    }

    private static void zzf(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f).toString());
        }
    }

    private static void zza(double d, double d2) {
        if (d > 90.0 || d < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d).toString());
        }
        if (d2 > 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d2).toString());
        }
    }

    private static int zzks(int n) {
        int n2 = n & 7;
        if (n2 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n).toString());
        }
        return n2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzasa.zza(this, parcel, n);
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String zzkt(int n) {
        switch (n) {
            case 1: {
                return "CIRCLE";
            }
        }
        return null;
    }

    public static zzarz zzw(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        zzarz zzarz2 = (zzarz)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return zzarz2;
    }

    public String toString() {
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", zzarz.zzkt(this.zzbjc), this.zzOn, this.zzbja, this.zzbjd, this.zzbje, Float.valueOf(this.zzbjf), this.zzbjg / 1000, this.zzbjh, this.zzbkw);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.zzbjd);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzbje);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + Float.floatToIntBits(this.zzbjf);
        n = 31 * n + this.zzbjc;
        n = 31 * n + this.zzbja;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof zzarz)) {
            return false;
        }
        zzarz zzarz2 = (zzarz)object;
        if (this.zzbjf != zzarz2.zzbjf) {
            return false;
        }
        if (this.zzbjd != zzarz2.zzbjd) {
            return false;
        }
        if (this.zzbje != zzarz2.zzbje) {
            return false;
        }
        return this.zzbjc == zzarz2.zzbjc;
    }
}

