/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.location.zzp;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class LocationResult
extends zza
implements ReflectedParcelable {
    static final List<Location> zzbjB = Collections.emptyList();
    private final int mVersionCode;
    private final List<Location> zzbjC;
    public static final Parcelable.Creator<LocationResult> CREATOR = new zzp();

    public static LocationResult create(List<Location> list) {
        if (list == null) {
            list = zzbjB;
        }
        return new LocationResult(2, list);
    }

    LocationResult(int n, List<Location> list) {
        this.mVersionCode = n;
        this.zzbjC = list;
    }

    public Location getLastLocation() {
        int n = this.zzbjC.size();
        if (n == 0) {
            return null;
        }
        return this.zzbjC.get(n - 1);
    }

    @NonNull
    public List<Location> getLocations() {
        return this.zzbjC;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzp.zza(this, parcel, n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int hashCode() {
        int n = 17;
        for (Location location : this.zzbjC) {
            long l = location.getTime();
            int n2 = (int)(l ^ l >>> 32);
            n = 31 * n + n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocationResult)) {
            return false;
        }
        LocationResult locationResult = (LocationResult)((Object)object);
        if (locationResult.zzbjC.size() != this.zzbjC.size()) {
            return false;
        }
        Iterator<Location> iterator = locationResult.zzbjC.iterator();
        Iterator<Location> iterator2 = this.zzbjC.iterator();
        while (iterator.hasNext()) {
            Location location = iterator2.next();
            Location location2 = iterator.next();
            if (location.getTime() == location2.getTime()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = String.valueOf(this.zzbjC);
        return new StringBuilder(27 + String.valueOf(string).length()).append("LocationResult[locations: ").append(string).append("]").toString();
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }

    public static LocationResult extractResult(Intent intent) {
        if (!LocationResult.hasResult(intent)) {
            return null;
        }
        return (LocationResult)intent.getExtras().getParcelable("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }
}

