/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.internal.zzasn;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

public class zzasm
extends zza
implements Geofence {
    private final String zzOV;
    private final long zzbkY;
    private final short zzbjJ;
    private final double zzbjK;
    private final double zzbjL;
    private final float zzbjM;
    private final int zzbjH;
    private final int zzbjN;
    private final int zzbjO;
    public static final Parcelable.Creator<zzasm> CREATOR = new zzasn();

    public zzasm(String string, int n, short s, double d, double d2, float f, long l, int n2, int n3) {
        zzasm.zzeT(string);
        zzasm.zzf(f);
        zzasm.zza(d, d2);
        n = zzasm.zzkA(n);
        this.zzbjJ = s;
        this.zzOV = string;
        this.zzbjK = d;
        this.zzbjL = d2;
        this.zzbjM = f;
        this.zzbkY = l;
        this.zzbjH = n;
        this.zzbjN = n2;
        this.zzbjO = n3;
    }

    public short zzIt() {
        return this.zzbjJ;
    }

    public double getLatitude() {
        return this.zzbjK;
    }

    public double getLongitude() {
        return this.zzbjL;
    }

    public float getRadius() {
        return this.zzbjM;
    }

    @Override
    public String getRequestId() {
        return this.zzOV;
    }

    public long getExpirationTime() {
        return this.zzbkY;
    }

    public int zzIu() {
        return this.zzbjH;
    }

    public int zzIv() {
        return this.zzbjN;
    }

    public int zzIw() {
        return this.zzbjO;
    }

    private static void zzeT(String string) {
        if (string == null || string.length() > 100) {
            String string2 = String.valueOf(string);
            throw new IllegalArgumentException(string2.length() != 0 ? "requestId is null or too long: ".concat(string2) : new String("requestId is null or too long: "));
        }
    }

    private static void zzf(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f).toString());
        }
    }

    private static void zza(double d, double d2) {
        if (d > 90.0 || d < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d).toString());
        }
        if (d2 > 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d2).toString());
        }
    }

    private static int zzkA(int n) {
        int n2 = n & 7;
        if (n2 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n).toString());
        }
        return n2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzasn.zza(this, parcel, n);
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String zzkB(int n) {
        switch (n) {
            case 1: {
                return "CIRCLE";
            }
        }
        return null;
    }

    public static zzasm zzw(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        zzasm zzasm2 = (zzasm)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return zzasm2;
    }

    public String toString() {
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", zzasm.zzkB(this.zzbjJ), this.zzOV, this.zzbjH, this.zzbjK, this.zzbjL, Float.valueOf(this.zzbjM), this.zzbjN / 1000, this.zzbjO, this.zzbkY);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.zzbjK);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzbjL);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + Float.floatToIntBits(this.zzbjM);
        n = 31 * n + this.zzbjJ;
        n = 31 * n + this.zzbjH;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof zzasm)) {
            return false;
        }
        zzasm zzasm2 = (zzasm)object;
        if (this.zzbjM != zzasm2.zzbjM) {
            return false;
        }
        if (this.zzbjK != zzasm2.zzbjK) {
            return false;
        }
        if (this.zzbjL != zzasm2.zzbjL) {
            return false;
        }
        return this.zzbjJ == zzasm2.zzbjJ;
    }
}

