/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import com.google.android.gms.internal.zzasm;
import com.google.android.gms.location.Geofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingEvent {
    private final int zzPY;
    private final int zzbjK;
    private final List<Geofence> zzbjL;
    private final Location zzbjM;

    private GeofencingEvent(int n, int n2, List<Geofence> list, Location location) {
        this.zzPY = n;
        this.zzbjK = n2;
        this.zzbjL = list;
        this.zzbjM = location;
    }

    public static GeofencingEvent fromIntent(Intent intent) {
        if (intent == null) {
            return null;
        }
        int n = intent.getIntExtra("gms_error_code", -1);
        int n2 = GeofencingEvent.zzx(intent);
        List<Geofence> list = GeofencingEvent.zzy(intent);
        Location location = (Location)intent.getParcelableExtra("com.google.android.location.intent.extra.triggering_location");
        return new GeofencingEvent(n, n2, list, location);
    }

    private static int zzx(Intent intent) {
        int n = intent.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        if (n == -1) {
            return -1;
        }
        if (n == 1 || n == 2 || n == 4) {
            return n;
        }
        return -1;
    }

    private static List<Geofence> zzy(Intent intent) {
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("com.google.android.location.intent.extra.geofence_list");
        if (arrayList == null) {
            return null;
        }
        ArrayList<Geofence> arrayList2 = new ArrayList<Geofence>(arrayList.size());
        for (byte[] byArray : arrayList) {
            arrayList2.add(zzasm.zzw(byArray));
        }
        return arrayList2;
    }

    public boolean hasError() {
        return this.zzPY != -1;
    }

    public int getErrorCode() {
        return this.zzPY;
    }

    public int getGeofenceTransition() {
        return this.zzbjK;
    }

    public List<Geofence> getTriggeringGeofences() {
        return this.zzbjL;
    }

    public Location getTriggeringLocation() {
        return this.zzbjM;
    }
}

