/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.internal.zzcfe;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

public final class zzcfd
extends zza
implements Geofence {
    private final String zzQz;
    private final long zzbjj;
    private final short zzbhL;
    private final double zzbhM;
    private final double zzbhN;
    private final float zzbhO;
    private final int zzbhJ;
    private final int zzbhP;
    private final int zzbhQ;
    public static final Parcelable.Creator<zzcfd> CREATOR = new zzcfe();

    public zzcfd(String string, int n, short s, double d, double d2, float f, long l, int n2, int n3) {
        float f2;
        String string2 = string;
        if (string2 == null || string2.length() > 100) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "requestId is null or too long: ".concat(string3) : new String("requestId is null or too long: "));
        }
        float f3 = f;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f3).toString());
        }
        double d3 = d2;
        double d4 = d;
        if (d4 > 90.0 || d4 < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d4).toString());
        }
        if (d3 > 180.0 || d3 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d3).toString());
        }
        int n4 = n;
        int n5 = n4 & 7;
        if (n5 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n4).toString());
        }
        n = n5;
        this.zzbhL = s;
        this.zzQz = string;
        this.zzbhM = d;
        this.zzbhN = d2;
        this.zzbhO = f;
        this.zzbjj = l;
        this.zzbhJ = n;
        this.zzbhP = n2;
        this.zzbhQ = n3;
    }

    @Override
    public final String getRequestId() {
        return this.zzQz;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzcfd zzcfd2 = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)zzcfd2.getRequestId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (long)zzcfd2.zzbjj);
        zzd.zza((Parcel)parcel2, (int)3, (short)zzcfd2.zzbhL);
        zzd.zza((Parcel)parcel2, (int)4, (double)zzcfd2.zzbhM);
        zzd.zza((Parcel)parcel2, (int)5, (double)zzcfd2.zzbhN);
        zzd.zza((Parcel)parcel2, (int)6, (float)zzcfd2.zzbhO);
        zzd.zzc((Parcel)parcel2, (int)7, (int)zzcfd2.zzbhJ);
        zzd.zzc((Parcel)parcel2, (int)8, (int)zzcfd2.zzbhP);
        zzd.zzc((Parcel)parcel2, (int)9, (int)zzcfd2.zzbhQ);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public static zzcfd zzl(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        zzcfd zzcfd2 = (zzcfd)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return zzcfd2;
    }

    public final String toString() {
        String string;
        Object[] objectArray = new Object[9];
        switch (this.zzbhL) {
            case 1: {
                string = "CIRCLE";
                break;
            }
            default: {
                string = null;
            }
        }
        objectArray[0] = string;
        objectArray[1] = this.zzQz;
        objectArray[2] = this.zzbhJ;
        objectArray[3] = this.zzbhM;
        objectArray[4] = this.zzbhN;
        objectArray[5] = Float.valueOf(this.zzbhO);
        objectArray[6] = this.zzbhP / 1000;
        objectArray[7] = this.zzbhQ;
        objectArray[8] = this.zzbjj;
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", objectArray);
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.zzbhM);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzbhN);
        n = n * 31 + (int)(l ^ l >>> 32);
        n = n * 31 + Float.floatToIntBits(this.zzbhO);
        n = n * 31 + this.zzbhL;
        return n * 31 + this.zzbhJ;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof zzcfd)) {
            return false;
        }
        zzcfd zzcfd2 = (zzcfd)object;
        if (this.zzbhO != zzcfd2.zzbhO) {
            return false;
        }
        if (this.zzbhM != zzcfd2.zzbhM) {
            return false;
        }
        if (this.zzbhN != zzcfd2.zzbhN) {
            return false;
        }
        return this.zzbhL == zzcfd2.zzbhL;
    }
}

