/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.safeparcel.zze;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.location.DetectedActivity;
import com.google.android.gms.location.zzb;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ActivityRecognitionResult
extends zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<ActivityRecognitionResult> CREATOR = new zzb();
    private List<DetectedActivity> zzbhy;
    private long zzbhz;
    private long zzbhA;
    private int zzbhB;
    private Bundle extras;

    public ActivityRecognitionResult(List<DetectedActivity> list, long l, long l2) {
        this(list, l, l2, 0, null);
    }

    public ActivityRecognitionResult(DetectedActivity detectedActivity, long l, long l2) {
        this(detectedActivity, l, l2, 0, null);
    }

    private ActivityRecognitionResult(DetectedActivity detectedActivity, long l, long l2, int n, Bundle bundle) {
        this(Collections.singletonList(detectedActivity), l, l2, 0, null);
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        Intent intent2 = intent;
        if (intent2 == null ? false : intent2.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT")) {
            return true;
        }
        List<ActivityRecognitionResult> list = ActivityRecognitionResult.zzj(intent);
        return list != null && !list.isEmpty();
    }

    /*
     * Unable to fully structure code
     */
    public static ActivityRecognitionResult extractResult(Intent var0) {
        var3_1 = var0;
        if (!ActivityRecognitionResult.hasResult(var3_1)) ** GOTO lbl-1000
        var4_2 = var3_1.getExtras().get("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT");
        if (var4_2 instanceof byte[]) {
            v0 = (ActivityRecognitionResult)zze.zza((byte[])((byte[])var4_2), ActivityRecognitionResult.CREATOR);
        } else if (var4_2 instanceof ActivityRecognitionResult) {
            v0 = (ActivityRecognitionResult)var4_2;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var1_3 = null;
        }
        if (v0 != null) {
            return var1_3;
        }
        var2_4 = ActivityRecognitionResult.zzj(var0);
        if (var2_4 == null || var2_4.isEmpty()) {
            return null;
        }
        return var2_4.get(var2_4.size() - 1);
    }

    @Nullable
    private static List<ActivityRecognitionResult> zzj(Intent intent) {
        Intent intent2 = intent;
        if (!(intent2 == null ? false : intent2.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST"))) {
            return null;
        }
        Parcelable.Creator<ActivityRecognitionResult> creator = CREATOR;
        String string = "com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST";
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST");
        if (arrayList == null) {
            return null;
        }
        ArrayList<ActivityRecognitionResult> arrayList2 = new ArrayList<ActivityRecognitionResult>(arrayList.size());
        ArrayList arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList3.get(i);
            byte[] byArray = (byte[])e;
            arrayList2.add((ActivityRecognitionResult)zze.zza((byte[])byArray, creator));
        }
        return arrayList2;
    }

    public DetectedActivity getMostProbableActivity() {
        return this.zzbhy.get(0);
    }

    public int getActivityConfidence(int n) {
        for (DetectedActivity detectedActivity : this.zzbhy) {
            if (detectedActivity.getType() != n) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    public List<DetectedActivity> getProbableActivities() {
        return this.zzbhy;
    }

    public long getTime() {
        return this.zzbhz;
    }

    public long getElapsedRealtimeMillis() {
        return this.zzbhA;
    }

    public String toString() {
        String string = String.valueOf(this.zzbhy);
        long l = this.zzbhz;
        long l2 = this.zzbhA;
        return new StringBuilder(124 + String.valueOf(string).length()).append("ActivityRecognitionResult [probableActivities=").append(string).append(", timeMillis=").append(l).append(", elapsedRealtimeMillis=").append(l2).append("]").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ActivityRecognitionResult activityRecognitionResult = (ActivityRecognitionResult)((Object)object);
        return this.zzbhz == activityRecognitionResult.zzbhz && this.zzbhA == activityRecognitionResult.zzbhA && this.zzbhB == activityRecognitionResult.zzbhB && zzbh.equal(this.zzbhy, activityRecognitionResult.zzbhy) && ActivityRecognitionResult.zzc(this.extras, activityRecognitionResult.extras);
    }

    private static boolean zzc(Bundle bundle, Bundle bundle2) {
        if (bundle == null && bundle2 == null) {
            return true;
        }
        if (bundle == null && bundle2 != null || bundle != null && bundle2 == null) {
            return false;
        }
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        for (String string : bundle.keySet()) {
            if (!bundle2.containsKey(string)) {
                return false;
            }
            if (!(bundle.get(string) == null ? bundle2.get(string) != null : (bundle.get(string) instanceof Bundle ? !ActivityRecognitionResult.zzc(bundle.getBundle(string), bundle2.getBundle(string)) : !bundle.get(string).equals(bundle2.get(string))))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzbhz, this.zzbhA, this.zzbhB, this.zzbhy, this.extras});
    }

    public ActivityRecognitionResult(List<DetectedActivity> list, long l, long l2, int n, Bundle bundle) {
        zzbr.zzb((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 detected activity");
        zzbr.zzb((l > 0L && l2 > 0L ? 1 : 0) != 0, (Object)"Must set times");
        this.zzbhy = list;
        this.zzbhz = l;
        this.zzbhA = l2;
        this.zzbhB = n;
        this.extras = bundle;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ActivityRecognitionResult activityRecognitionResult = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, activityRecognitionResult.zzbhy, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (long)activityRecognitionResult.zzbhz);
        zzd.zza((Parcel)parcel2, (int)3, (long)activityRecognitionResult.zzbhA);
        zzd.zzc((Parcel)parcel2, (int)4, (int)activityRecognitionResult.zzbhB);
        zzd.zza((Parcel)parcel2, (int)5, (Bundle)activityRecognitionResult.extras, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

