/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.location.zzq;
import java.util.Arrays;

public final class LocationRequest
extends zza
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private int mPriority;
    private long zzbib;
    private long zzbic;
    private boolean zzaXh;
    private long zzbhK;
    private int zzbid;
    private float zzbie;
    private long zzbif;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new zzq();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mPriority = 102;
        this.zzbib = 3600000L;
        this.zzbic = 600000L;
        this.zzaXh = false;
        this.zzbhK = Long.MAX_VALUE;
        this.zzbid = Integer.MAX_VALUE;
        this.zzbie = 0.0f;
        this.zzbif = 0L;
    }

    public final LocationRequest setPriority(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
        this.mPriority = n;
        return this;
    }

    public final int getPriority() {
        return this.mPriority;
    }

    public final LocationRequest setInterval(long l) {
        LocationRequest.zzI(l);
        this.zzbib = l;
        if (!this.zzaXh) {
            this.zzbic = (long)((double)this.zzbib / 6.0);
        }
        return this;
    }

    public final long getInterval() {
        return this.zzbib;
    }

    public final LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zzI(l);
        this.zzbif = l;
        return this;
    }

    public final long getMaxWaitTime() {
        long l = this.zzbif;
        if (l < this.zzbib) {
            l = this.zzbib;
        }
        return l;
    }

    public final LocationRequest setFastestInterval(long l) {
        LocationRequest.zzI(l);
        this.zzaXh = true;
        this.zzbic = l;
        return this;
    }

    public final long getFastestInterval() {
        return this.zzbic;
    }

    public final LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.zzbhK = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.zzbhK < 0L) {
            this.zzbhK = 0L;
        }
        return this;
    }

    public final LocationRequest setExpirationTime(long l) {
        this.zzbhK = l;
        if (this.zzbhK < 0L) {
            this.zzbhK = 0L;
        }
        return this;
    }

    public final long getExpirationTime() {
        return this.zzbhK;
    }

    public final LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.zzbid = n;
        return this;
    }

    public final int getNumUpdates() {
        return this.zzbid;
    }

    public final LocationRequest setSmallestDisplacement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
        this.zzbie = f;
        return this;
    }

    public final float getSmallestDisplacement() {
        return this.zzbie;
    }

    private static void zzI(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    LocationRequest(int n, long l, long l2, boolean bl, long l3, int n2, float f, long l4) {
        this.mPriority = n;
        this.zzbib = l;
        this.zzbic = l2;
        this.zzaXh = bl;
        this.zzbhK = l3;
        this.zzbid = n2;
        this.zzbie = f;
        this.zzbif = l4;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationRequest locationRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, (int)locationRequest.mPriority);
        zzd.zza((Parcel)parcel2, (int)2, (long)locationRequest.zzbib);
        zzd.zza((Parcel)parcel2, (int)3, (long)locationRequest.zzbic);
        zzd.zza((Parcel)parcel2, (int)4, (boolean)locationRequest.zzaXh);
        zzd.zza((Parcel)parcel2, (int)5, (long)locationRequest.zzbhK);
        zzd.zzc((Parcel)parcel2, (int)6, (int)locationRequest.zzbid);
        zzd.zza((Parcel)parcel2, (int)7, (float)locationRequest.zzbie);
        zzd.zza((Parcel)parcel2, (int)8, (long)locationRequest.zzbif);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Request[");
        switch (this.mPriority) {
            case 100: {
                string = "PRIORITY_HIGH_ACCURACY";
                break;
            }
            case 102: {
                string = "PRIORITY_BALANCED_POWER_ACCURACY";
                break;
            }
            case 104: {
                string = "PRIORITY_LOW_POWER";
                break;
            }
            case 105: {
                string = "PRIORITY_NO_POWER";
                break;
            }
            default: {
                string = "???";
            }
        }
        stringBuilder2.append(string);
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzbib).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzbic).append("ms");
        if (this.zzbif > this.zzbib) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzbif).append("ms");
        }
        if (this.zzbie > 0.0f) {
            stringBuilder.append(" smallestDisplacement=");
            stringBuilder.append(this.zzbie).append("m");
        }
        if (this.zzbhK != Long.MAX_VALUE) {
            long l = this.zzbhK - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzbid != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzbid);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.mPriority, this.zzbib, Float.valueOf(this.zzbie), this.zzbif});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.mPriority == locationRequest.mPriority && this.zzbib == locationRequest.zzbib && this.zzbic == locationRequest.zzbic && this.zzaXh == locationRequest.zzaXh && this.zzbhK == locationRequest.zzbhK && this.zzbid == locationRequest.zzbid && this.zzbie == locationRequest.zzbie && this.getMaxWaitTime() == locationRequest.getMaxWaitTime();
    }
}

