/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.internal.zzcdr;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

public final class zzcdq
extends zza
implements Geofence {
    private final String zzQx;
    private final long zzbjf;
    private final short zzbhH;
    private final double zzbhI;
    private final double zzbhJ;
    private final float zzbhK;
    private final int zzbhF;
    private final int zzbhL;
    private final int zzbhM;
    public static final Parcelable.Creator<zzcdq> CREATOR = new zzcdr();

    public zzcdq(String string, int n, short s, double d, double d2, float f, long l, int n2, int n3) {
        float f2;
        String string2 = string;
        if (string2 == null || string2.length() > 100) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "requestId is null or too long: ".concat(string3) : new String("requestId is null or too long: "));
        }
        float f3 = f;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f3).toString());
        }
        double d3 = d2;
        double d4 = d;
        if (d4 > 90.0 || d4 < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d4).toString());
        }
        if (d3 > 180.0 || d3 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d3).toString());
        }
        int n4 = n;
        int n5 = n4 & 7;
        if (n5 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n4).toString());
        }
        n = n5;
        this.zzbhH = s;
        this.zzQx = string;
        this.zzbhI = d;
        this.zzbhJ = d2;
        this.zzbhK = f;
        this.zzbjf = l;
        this.zzbhF = n;
        this.zzbhL = n2;
        this.zzbhM = n3;
    }

    @Override
    public final String getRequestId() {
        return this.zzQx;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzcdq zzcdq2 = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)zzcdq2.getRequestId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (long)zzcdq2.zzbjf);
        zzd.zza((Parcel)parcel2, (int)3, (short)zzcdq2.zzbhH);
        zzd.zza((Parcel)parcel2, (int)4, (double)zzcdq2.zzbhI);
        zzd.zza((Parcel)parcel2, (int)5, (double)zzcdq2.zzbhJ);
        zzd.zza((Parcel)parcel2, (int)6, (float)zzcdq2.zzbhK);
        zzd.zzc((Parcel)parcel2, (int)7, (int)zzcdq2.zzbhF);
        zzd.zzc((Parcel)parcel2, (int)8, (int)zzcdq2.zzbhL);
        zzd.zzc((Parcel)parcel2, (int)9, (int)zzcdq2.zzbhM);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public static zzcdq zzk(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        zzcdq zzcdq2 = (zzcdq)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return zzcdq2;
    }

    public final String toString() {
        String string;
        Object[] objectArray = new Object[9];
        switch (this.zzbhH) {
            case 1: {
                string = "CIRCLE";
                break;
            }
            default: {
                string = null;
            }
        }
        objectArray[0] = string;
        objectArray[1] = this.zzQx;
        objectArray[2] = this.zzbhF;
        objectArray[3] = this.zzbhI;
        objectArray[4] = this.zzbhJ;
        objectArray[5] = Float.valueOf(this.zzbhK);
        objectArray[6] = this.zzbhL / 1000;
        objectArray[7] = this.zzbhM;
        objectArray[8] = this.zzbjf;
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", objectArray);
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.zzbhI);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzbhJ);
        n = n * 31 + (int)(l ^ l >>> 32);
        n = n * 31 + Float.floatToIntBits(this.zzbhK);
        n = n * 31 + this.zzbhH;
        return n * 31 + this.zzbhF;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof zzcdq)) {
            return false;
        }
        zzcdq zzcdq2 = (zzcdq)object;
        if (this.zzbhK != zzcdq2.zzbhK) {
            return false;
        }
        if (this.zzbhI != zzcdq2.zzbhI) {
            return false;
        }
        if (this.zzbhJ != zzcdq2.zzbhJ) {
            return false;
        }
        return this.zzbhH == zzcdq2.zzbhH;
    }
}

