/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.location.zzq;
import java.util.Arrays;

public final class LocationRequest
extends zza
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private int mPriority;
    private long zzhxr;
    private long zzhxs;
    private boolean zzgzm;
    private long zzhxa;
    private int zzhxt;
    private float zzhxu;
    private long zzhxv;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new zzq();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mPriority = 102;
        this.zzhxr = 3600000L;
        this.zzhxs = 600000L;
        this.zzgzm = false;
        this.zzhxa = Long.MAX_VALUE;
        this.zzhxt = Integer.MAX_VALUE;
        this.zzhxu = 0.0f;
        this.zzhxv = 0L;
    }

    public final LocationRequest setPriority(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
        this.mPriority = n;
        return this;
    }

    public final int getPriority() {
        return this.mPriority;
    }

    public final LocationRequest setInterval(long l) {
        LocationRequest.zzai(l);
        this.zzhxr = l;
        if (!this.zzgzm) {
            this.zzhxs = (long)((double)this.zzhxr / 6.0);
        }
        return this;
    }

    public final long getInterval() {
        return this.zzhxr;
    }

    public final LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zzai(l);
        this.zzhxv = l;
        return this;
    }

    public final long getMaxWaitTime() {
        long l = this.zzhxv;
        if (l < this.zzhxr) {
            l = this.zzhxr;
        }
        return l;
    }

    public final LocationRequest setFastestInterval(long l) {
        LocationRequest.zzai(l);
        this.zzgzm = true;
        this.zzhxs = l;
        return this;
    }

    public final long getFastestInterval() {
        return this.zzhxs;
    }

    public final LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.zzhxa = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.zzhxa < 0L) {
            this.zzhxa = 0L;
        }
        return this;
    }

    public final LocationRequest setExpirationTime(long l) {
        this.zzhxa = l;
        if (this.zzhxa < 0L) {
            this.zzhxa = 0L;
        }
        return this;
    }

    public final long getExpirationTime() {
        return this.zzhxa;
    }

    public final LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.zzhxt = n;
        return this;
    }

    public final int getNumUpdates() {
        return this.zzhxt;
    }

    public final LocationRequest setSmallestDisplacement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
        this.zzhxu = f;
        return this;
    }

    public final float getSmallestDisplacement() {
        return this.zzhxu;
    }

    private static void zzai(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    LocationRequest(int n, long l, long l2, boolean bl, long l3, int n2, float f, long l4) {
        this.mPriority = n;
        this.zzhxr = l;
        this.zzhxs = l2;
        this.zzgzm = bl;
        this.zzhxa = l3;
        this.zzhxt = n2;
        this.zzhxu = f;
        this.zzhxv = l4;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationRequest locationRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, (int)locationRequest.mPriority);
        zzd.zza((Parcel)parcel2, (int)2, (long)locationRequest.zzhxr);
        zzd.zza((Parcel)parcel2, (int)3, (long)locationRequest.zzhxs);
        zzd.zza((Parcel)parcel2, (int)4, (boolean)locationRequest.zzgzm);
        zzd.zza((Parcel)parcel2, (int)5, (long)locationRequest.zzhxa);
        zzd.zzc((Parcel)parcel2, (int)6, (int)locationRequest.zzhxt);
        zzd.zza((Parcel)parcel2, (int)7, (float)locationRequest.zzhxu);
        zzd.zza((Parcel)parcel2, (int)8, (long)locationRequest.zzhxv);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Request[");
        switch (this.mPriority) {
            case 100: {
                string = "PRIORITY_HIGH_ACCURACY";
                break;
            }
            case 102: {
                string = "PRIORITY_BALANCED_POWER_ACCURACY";
                break;
            }
            case 104: {
                string = "PRIORITY_LOW_POWER";
                break;
            }
            case 105: {
                string = "PRIORITY_NO_POWER";
                break;
            }
            default: {
                string = "???";
            }
        }
        stringBuilder2.append(string);
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzhxr).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzhxs).append("ms");
        if (this.zzhxv > this.zzhxr) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzhxv).append("ms");
        }
        if (this.zzhxu > 0.0f) {
            stringBuilder.append(" smallestDisplacement=");
            stringBuilder.append(this.zzhxu).append("m");
        }
        if (this.zzhxa != Long.MAX_VALUE) {
            long l = this.zzhxa - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzhxt != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzhxt);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.mPriority, this.zzhxr, Float.valueOf(this.zzhxu), this.zzhxv});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.mPriority == locationRequest.mPriority && this.zzhxr == locationRequest.zzhxr && this.zzhxs == locationRequest.zzhxs && this.zzgzm == locationRequest.zzgzm && this.zzhxa == locationRequest.zzhxa && this.zzhxt == locationRequest.zzhxt && this.zzhxu == locationRequest.zzhxu && this.getMaxWaitTime() == locationRequest.getMaxWaitTime();
    }
}

