/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzcm;
import com.google.android.gms.common.api.internal.zzcz;
import com.google.android.gms.common.api.internal.zzde;
import com.google.android.gms.common.internal.zzbj;
import com.google.android.gms.internal.zzceo;
import com.google.android.gms.internal.zzceu;
import com.google.android.gms.internal.zzcev;
import com.google.android.gms.internal.zzcfo;
import com.google.android.gms.internal.zzcgc;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.zzg;
import com.google.android.gms.location.zzh;
import com.google.android.gms.location.zzi;
import com.google.android.gms.location.zzj;
import com.google.android.gms.location.zzk;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public class FusedLocationProviderClient
extends GoogleApi<Api.ApiOptions.NoOptions> {
    public static final String KEY_VERTICAL_ACCURACY = "verticalAccuracy";

    public FusedLocationProviderClient(@NonNull Context context) {
        super(context, LocationServices.API, null, (zzcz)new com.google.android.gms.common.api.internal.zzg());
    }

    public FusedLocationProviderClient(@NonNull Activity activity) {
        super(activity, LocationServices.API, null, (zzcz)new com.google.android.gms.common.api.internal.zzg());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Location> getLastLocation() {
        return this.zza(new zzg(this));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<LocationAvailability> getLocationAvailability() {
        return this.zza(new zzh(this));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> requestLocationUpdates(LocationRequest locationRequest, LocationCallback locationCallback, @Nullable Looper looper) {
        zzcfo zzcfo2 = zzcfo.zza(locationRequest);
        Looper looper2 = looper;
        LocationCallback locationCallback2 = locationCallback;
        zzcfo zzcfo3 = zzcfo2;
        FusedLocationProviderClient fusedLocationProviderClient = this;
        zzci zzci2 = zzcm.zzb((Object)locationCallback2, (Looper)zzcgc.zzb(looper2), (String)LocationCallback.class.getSimpleName());
        zzi zzi2 = new zzi(fusedLocationProviderClient, zzci2, zzcfo3, zzci2);
        zzj zzj2 = new zzj(fusedLocationProviderClient, zzci2.zzajo());
        return fusedLocationProviderClient.zza(zzi2, zzj2);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> requestLocationUpdates(LocationRequest locationRequest, PendingIntent pendingIntent) {
        return zzbj.zzb(LocationServices.FusedLocationApi.requestLocationUpdates(this.zzago(), locationRequest, pendingIntent));
    }

    public Task<Void> removeLocationUpdates(PendingIntent pendingIntent) {
        return zzbj.zzb(LocationServices.FusedLocationApi.removeLocationUpdates(this.zzago(), pendingIntent));
    }

    public Task<Void> removeLocationUpdates(LocationCallback locationCallback) {
        return zzde.zza((Task)this.zza(zzcm.zzb((Object)locationCallback, (String)LocationCallback.class.getSimpleName())));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> setMockMode(boolean bl) {
        return zzbj.zzb(LocationServices.FusedLocationApi.setMockMode(this.zzago(), bl));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> setMockLocation(Location location) {
        return zzbj.zzb(LocationServices.FusedLocationApi.setMockLocation(this.zzago(), location));
    }

    public Task<Void> flushLocations() {
        return zzbj.zzb(LocationServices.FusedLocationApi.flushLocations(this.zzago()));
    }

    private final zzceu zzc(TaskCompletionSource<Boolean> taskCompletionSource) {
        return new zzk(this, taskCompletionSource);
    }

    static /* synthetic */ zzceu zza(FusedLocationProviderClient fusedLocationProviderClient, TaskCompletionSource taskCompletionSource) {
        return fusedLocationProviderClient.zzc((TaskCompletionSource<Boolean>)taskCompletionSource);
    }

    static final class zza
    extends zzcev {
        private final TaskCompletionSource<Void> zzedx;

        public zza(TaskCompletionSource<Void> taskCompletionSource) {
            this.zzedx = taskCompletionSource;
        }

        @Override
        public final void zza(zzceo zzceo2) {
            TaskCompletionSource<Void> taskCompletionSource = this.zzedx;
            zzde.zza((Status)zzceo2.getStatus(), null, taskCompletionSource);
        }
    }
}

