/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgp;
import com.google.android.gms.internal.zzbgq;
import com.google.android.gms.internal.zzcfs;
import com.google.android.gms.location.ActivityTransition;
import com.google.android.gms.location.zze;
import com.google.android.gms.location.zzf;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class ActivityTransitionRequest
extends zzbgl {
    public static final Parcelable.Creator<ActivityTransitionRequest> CREATOR = new zzf();
    public static final Comparator<ActivityTransition> IS_SAME_TRANSITION = new zze();
    private final List<ActivityTransition> zziqz;
    @Nullable
    private final String mTag;
    private final List<zzcfs> zzira;

    @Hide
    public ActivityTransitionRequest(List<ActivityTransition> list, @Nullable String string, @Nullable List<zzcfs> list2) {
        zzbq.checkNotNull(list, (Object)"transitions can't be null");
        zzbq.checkArgument((list.size() > 0 ? 1 : 0) != 0, (Object)"transitions can't be empty.");
        List<ActivityTransition> list3 = list;
        TreeSet<ActivityTransition> treeSet = new TreeSet<ActivityTransition>(IS_SAME_TRANSITION);
        for (ActivityTransition activityTransition : list3) {
            zzbq.checkArgument((boolean)treeSet.add(activityTransition), (Object)String.format("Found duplicated transition: %s.", new Object[]{activityTransition}));
        }
        this.zziqz = Collections.unmodifiableList(list);
        this.mTag = string;
        this.zzira = list2 == null ? Collections.emptyList() : Collections.unmodifiableList(list2);
    }

    public ActivityTransitionRequest(List<ActivityTransition> list) {
        this(list, null, null);
    }

    public void serializeToIntentExtra(Intent intent) {
        zzbgq.zza((zzbgp)this, (Intent)intent, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_TRANSITION_REQUEST");
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ActivityTransitionRequest activityTransitionRequest = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, activityTransitionRequest.zziqz, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)activityTransitionRequest.mTag, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)3, activityTransitionRequest.zzira, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ActivityTransitionRequest activityTransitionRequest = (ActivityTransitionRequest)((Object)object);
        return zzbg.equal(this.zziqz, activityTransitionRequest.zziqz) && zzbg.equal((Object)this.mTag, (Object)activityTransitionRequest.mTag) && zzbg.equal(this.zzira, activityTransitionRequest.zzira);
    }

    public String toString() {
        String string = String.valueOf(this.zziqz);
        String string2 = this.mTag;
        String string3 = String.valueOf(this.zzira);
        return new StringBuilder(61 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("ActivityTransitionRequest [mTransitions=").append(string).append(", mTag='").append(string2).append('\'').append(", mClients=").append(string3).append(']').toString();
    }

    public int hashCode() {
        int n = this.zziqz.hashCode();
        n = n * 31 + (this.mTag != null ? this.mTag.hashCode() : 0);
        return n * 31 + (this.zzira != null ? this.zzira.hashCode() : 0);
    }
}

