/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zzbh;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.zzq;
import java.util.ArrayList;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="GeofencingRequestCreator")
public class GeofencingRequest
extends AbstractSafeParcelable {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zzq();
    @SafeParcelable.Field(id=1, getter="getParcelableGeofences")
    private final List<zzbh> zzap;
    @SafeParcelable.Field(id=2, getter="getInitialTrigger")
    private final int zzaq;
    @SafeParcelable.Field(id=3, getter="getTag", defaultValue="")
    private final String tag;

    @SafeParcelable.Constructor
    GeofencingRequest(@SafeParcelable.Param(id=1) List<zzbh> list, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String string) {
        this.zzap = list;
        this.zzaq = n;
        this.tag = string;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zzap);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.zzaq;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GeofencingRequest geofencingRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)1, geofencingRequest.zzap, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)geofencingRequest.getInitialTrigger());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)geofencingRequest.tag, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GeofencingRequest[");
        stringBuilder.append("geofences=");
        stringBuilder.append(this.zzap);
        int n = this.zzaq;
        stringBuilder.append(new StringBuilder(30).append(", initialTrigger=").append(n).append(", ").toString());
        String string = String.valueOf(this.tag);
        stringBuilder.append(string.length() != 0 ? "tag=".concat(string) : new String("tag="));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final class Builder {
        private final List<zzbh> zzap = new ArrayList<zzbh>();
        private int zzaq = 5;
        private String tag = "";

        public final Builder addGeofence(Geofence geofence) {
            Preconditions.checkNotNull((Object)geofence, (Object)"geofence can't be null.");
            Preconditions.checkArgument((boolean)(geofence instanceof zzbh), (Object)"Geofence must be created using Geofence.Builder.");
            this.zzap.add((zzbh)geofence);
            return this;
        }

        public final Builder addGeofences(List<Geofence> list) {
            if (list == null || list.isEmpty()) {
                return this;
            }
            for (Geofence geofence : list) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public final Builder setInitialTrigger(int n) {
            this.zzaq = n & 7;
            return this;
        }

        public final GeofencingRequest build() {
            Preconditions.checkArgument((!this.zzap.isEmpty() ? 1 : 0) != 0, (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.zzap, this.zzaq, this.tag);
        }
    }
}

