/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.ActivityTransition;
import com.google.android.gms.location.zzh;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionEventCreator")
public class ActivityTransitionEvent
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<ActivityTransitionEvent> CREATOR = new zzh();
    @SafeParcelable.Field(id=1, getter="getActivityType")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getTransitionType")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getElapsedRealTimeNanos")
    private final long zzc;

    @SafeParcelable.Constructor
    public ActivityTransitionEvent(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) long l) {
        ActivityTransition.zza(n2);
        this.zza = n;
        this.zzb = n2;
        this.zzc = l;
    }

    public int getActivityType() {
        return this.zza;
    }

    public int getTransitionType() {
        return this.zzb;
    }

    public long getElapsedRealTimeNanos() {
        return this.zzc;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, this.zzc});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ActivityTransitionEvent)) {
            return false;
        }
        ActivityTransitionEvent activityTransitionEvent = (ActivityTransitionEvent)((Object)object);
        return this.zza == activityTransitionEvent.zza && this.zzb == activityTransitionEvent.zzb && this.zzc == activityTransitionEvent.zzc;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.zza;
        stringBuilder.append(new StringBuilder(24).append("ActivityType ").append(n).toString());
        stringBuilder.append(" ");
        n = this.zzb;
        stringBuilder.append(new StringBuilder(26).append("TransitionType ").append(n).toString());
        stringBuilder.append(" ");
        long l = this.zzc;
        stringBuilder.append(new StringBuilder(41).append("ElapsedRealTimeNanos ").append(l).toString());
        return stringBuilder.toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ActivityTransitionEvent activityTransitionEvent = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)activityTransitionEvent.getActivityType());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)activityTransitionEvent.getTransitionType());
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)3, (long)activityTransitionEvent.getElapsedRealTimeNanos());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

